Attribute VB_Name = "WinAPI_Module"
Option Explicit

'Get File Version
Public Type VS_FIXEDFILEINFO
        dwSignature As Long
        dwStrucVersion As Long         '  e.g. 0x00000042 = "0.42"
        dwFileVersionMS As Long        '  e.g. 0x00030075 = "3.75"
        dwFileVersionLS As Long        '  e.g. 0x00000031 = "0.31"
        dwProductVersionMS As Long     '  e.g. 0x00030010 = "3.10"
        dwProductVersionLS As Long     '  e.g. 0x00000031 = "0.31"
        dwFileFlagsMask As Long        '  = 0x3F for version "0.42"
        dwFileFlags As Long            '  e.g. VFF_DEBUG Or VFF_PRERELEASE
        dwFileOS As Long               '  e.g. VOS_DOS_WINDOWS16
        dwFileType As Long             '  e.g. VFT_DRIVER
        dwFileSubtype As Long          '  e.g. VFT2_DRV_KEYBOARD
        dwFileDateMS As Long           '  e.g. 0
        dwFileDateLS As Long           '  e.g. 0
End Type
Public Declare Function GetFileVersionInfoSize Lib "version.dll" Alias "GetFileVersionInfoSizeA" ( _
                                                                ByVal lptstrFilename As String, _
                                                                lpdwHandle As Long _
                                                                ) As Long
Public Declare Function GetFileVersionInfo Lib "version.dll" Alias "GetFileVersionInfoA" ( _
                                                                ByVal lptstrFilename As String, _
                                                                ByVal dwHandle As Long, _
                                                                ByVal dwLen As Long, _
                                                                lpData As Any _
                                                                ) As Long
Public Declare Function VerQueryValue Lib "version.dll" Alias "VerQueryValueA" ( _
                                                                pBlock As Any, _
                                                                ByVal lpSubBlock As String, _
                                                                lplpBuffer As Long, _
                                                                puLen As Long _
                                                                ) As Long
Public Declare Sub memmove Lib "kernel32" Alias "RtlMoveMemory" ( _
                                                                dst As Any, _
                                                                src As Any, _
                                                                ByVal num As Long _
                                                                )

'INI File Read API
Declare Function GetPrivateProfileString Lib "kernel32" _
                Alias "GetPrivateProfileStringA" _
                (ByVal lpApplicationName As String, _
                ByVal lpKeyName As Any, _
                ByVal lpDefault As String, _
                ByVal lpReturnedString As String, _
                ByVal nSize As Long, _
                ByVal lpFileName As String _
                ) As Long
    
'INI File Write API
Declare Function WritePrivateProfileString Lib "kernel32" _
                Alias "WritePrivateProfileStringA" _
                (ByVal lpApplicationName As String, _
                ByVal lpKeyName As Any, _
                ByVal lpString As String, _
                ByVal lpFileName As String _
                ) As Long

'INI File Definition
Public Const INIFName   As String = ".\PCardRW32.ini"

'DLL File Version Variable
Public DLLMajor     As Long
Public DLLMinor     As Long
Public DLLRevisionH As Long
Public DLLRevisionL As Long

'INI File Read
Public Function ReadIni(section As String, entry As String, fileID As String) As String
    Dim ret     As Long
    Dim s       As String * 1024
    
    ret = GetPrivateProfileString(section, entry, "", s, 1024, fileID)
    ReadIni = Left(s, InStr(s, Chr(0)) - 1)
    
End Function

'INI File Update
Public Sub WriteIni(section As String, entry As String, entryData As String, fileID As String)
    Dim ret     As Long
    
    ret = WritePrivateProfileString(section, entry, entryData, fileID)
    
End Sub
'INI File Create
Public Sub CreateIni()
    Dim strLog  As String
    
    If DLLMajor = 2 Then        'PCardRW32.DLL File Version 2.x.x.x `
        strLog = "-1"
    ElseIf DLLMajor = 1 Then    'PCardRW32.DLL File Version 1.x.x.x `
        strLog = "0"
    End If
    
    'Application@Name
    WriteIni "Application", "Name", "PCardRW32DLL INI File", INIFName
    
    'LOG Configuration
    WriteIni "Log", "Logging", strLog, INIFName
    WriteIni "Log", "LogFileName", ".\\PCardRW32_%03d.log", INIFName
        
    'Send Delay Time Configuration
    WriteIni "Delay", "Delay", "0", INIFName
    
    'WriteFile API TimeOut Configuration
    WriteIni "TimeOut", "WriteFileTimeOut", "5000", INIFName
    
End Sub

'
'   o[W擾
'
'       FullPath   o[W擾t@C̃tpX
'       Major      W[ [Xԍ  i[
'       Minor      }Ci[ [Xԍ  i[
'       RevisionH  rWԍ         i[
'       RevisionL  rWԍ         i[
'
'       ߂l      True:   False:s
'
Public Function GetVersion(ByVal FullPath As String, _
                            Major As Long, _
                            Minor As Long, _
                            RevisionH As Long, _
                            RevisionL As Long) As Boolean

    GetVersion = False

    Dim ret         As Boolean
    Dim nLen        As Long
    Dim nHandle     As Long

    '   o[W񂪎擾ł邩`FbN
    Dim nVerInfoSize    As Long
    nVerInfoSize = GetFileVersionInfoSize(FullPath, 0)
    If nVerInfoSize < 1 Then Exit Function

    '   o[W擾
    Dim cVerInfo()  As Byte
    ReDim cVerInfo(nVerInfoSize) As Byte
    ret = GetFileVersionInfo(FullPath, 0, nVerInfoSize, cVerInfo(0))
    If ret = False Then Exit Function

    Dim vf  As VS_FIXEDFILEINFO
    ret = VerQueryValue(cVerInfo(0), "\", nHandle, nLen)
    memmove vf.dwSignature, ByVal nHandle, nLen

    'File Version 
    '   Major, Minor, Revision ɕҏW
    '(Product Version Ȃ dwProductVersionMS  dwProductVersionLS g)
    Dim sMs As String
    Dim sLs As String
    sMs = Right("00000000" & Hex(vf.dwFileVersionMS), 8)
    sLs = Right("00000000" & Hex(vf.dwFileVersionLS), 8)

    Major = Val("&H0" & Left(sMs, 4))
    Minor = Val("&H0" & Right(sMs, 4))
    RevisionH = Val("&H0" & Left(sLs, 4))
    RevisionL = Val("&H0" & Right(sLs, 4))

    GetVersion = True

End Function


