Attribute VB_Name = "basPCardRW32"
'///////////////////////////////////////////////////////////////////////////////
'// Device       FCard Reader/Writer Device Communication Control Liblary
'//
'// File Name    FbasPCardRW32.bas
'//
'// Purpose      FVisual Basic 6 Standard Module
'//
'// Update       F2013.03.26    Panasonic System Networks Co.,Ltd.
'//
'///////////////////////////////////////////////////////////////////////////////

' DLL-萔 `錾
Public Const RET_CRW_SUCCESS                As Integer = 0
Public Const RET_CRW_ACK                    As Integer = 0
Public Const RET_CRW_RESPONSE               As Integer = 0
Public Const RET_CRW_FAILURE                As Integer = 1
Public Const RET_CRW_NAK                    As Integer = 1
Public Const RET_CRW_READY                  As Integer = 1
Public Const RET_CRW_BUSY                   As Integer = 2
Public Const RET_CRW_NAK_BINARY             As Integer = 2

Public Const RET_CRW_ERR_PARAM              As Integer = 100
Public Const RET_CRW_ERR_PORT               As Integer = 101
Public Const RET_CRW_ERR_RES_TIMEOUT        As Integer = 110
Public Const RET_CRW_ERR_CTS_TIMEOUT        As Integer = 111
Public Const RET_CRW_ERR_DSR                As Integer = 112
' ʃo[WƂ̌݊̈
Public Const RET_CRW_ERR_DSR_TIMEOUT        As Integer = 112
Public Const RET_CRW_ERR_BUSY_TIMEOUT       As Integer = 113
Public Const RET_CRW_ERR_BCC_RETRY          As Integer = 120
Public Const RET_CRW_ERR_BUFFEROVER         As Integer = 130
Public Const RET_CRW_ERR_BUSY               As Integer = 140

Public Const RET_CRW_ERR_COMM_WRITE         As Integer = 200
Public Const RET_CRW_ERR_COMM_READ          As Integer = 201

' Cxg萔 `
Public Const EVT_RSP_CRW_RESPONSE           As Long = &H1&
Public Const EVT_RSP_CRW_READY              As Long = &H2&
Public Const EVT_RSP_CRW_BUSY               As Long = &H4&
Public Const EVT_RSP_CRW_CANCELED           As Long = &H8&
Public Const EVT_RSP_CRW_ERR_RES_TIMEOUT    As Long = &H100&
Public Const EVT_RSP_CRW_ERR_CTS_TIMEOUT    As Long = &H200&
Public Const EVT_RSP_CRW_ERR_DSR            As Long = &H400&
Public Const EVT_RSP_CRW_ERR_BCC_RETRY      As Long = &H800&
Public Const EVT_RSP_CRW_ERR_COMM_WRITE     As Long = &H1000&
Public Const EVT_RSP_CRW_ERR_COMM_READ      As Long = &H2000&
Public Const EVT_RSP_CRW_ALL                As Long = &HFFFFFFFF

Public Const EVT_BIN_CRW_RESPONSE           As Long = &H1&
Public Const EVT_BIN_CRW_CANCELED           As Long = &H8&
Public Const EVT_BIN_CRW_ERR_RES_TIMEOUT    As Long = &H100&
Public Const EVT_BIN_CRW_ERR_CTS_TIMEOUT    As Long = &H200&
Public Const EVT_BIN_CRW_ERR_DSR            As Long = &H400&
Public Const EVT_BIN_CRW_ERR_BCC_RETRY      As Long = &H800&
Public Const EVT_BIN_CRW_ERR_COMM_WRITE     As Long = &H1000&
Public Const EVT_BIN_CRW_ERR_COMM_READ      As Long = &H2000&
Public Const EVT_BIN_CRW_ALL                As Long = &HFFFFFFFF

Public Const EVT_BCC_CRW_RESPONSE           As Long = &H1&
Public Const EVT_BCC_CRW_CANCELED           As Long = &H8&
Public Const EVT_BCC_CRW_ERR_RES_TIMEOUT    As Long = &H100&
Public Const EVT_BCC_CRW_ERR_CTS_TIMEOUT    As Long = &H200&
Public Const EVT_BCC_CRW_ERR_DSR            As Long = &H400&
Public Const EVT_BCC_CRW_ERR_BCC_RETRY      As Long = &H800&
Public Const EVT_BCC_CRW_ERR_COMM_WRITE     As Long = &H1000&
Public Const EVT_BCC_CRW_ERR_COMM_READ      As Long = &H2000&
Public Const EVT_BCC_CRW_ALL                As Long = &HFFFFFFFF

Public Const EVT_CRW_RXCHAR                 As Long = &H1&
Public Const EVT_CRW_TXEMPTY                As Long = &H4&
Public Const EVT_CRW_ERR_FRAME              As Long = &H100&
Public Const EVT_CRW_ERR_OVERRUN            As Long = &H200&
Public Const EVT_CRW_ERR_PARITY             As Long = &H400&
Public Const EVT_CRW_CTS                    As Long = &H1000&
Public Const EVT_CRW_DSR                    As Long = &H2000&
Public Const EVT_CRW_RLSD                   As Long = &H4000&
Public Const EVT_CRW_BREAK                  As Long = &H8000&
Public Const EVT_CRW_RING                   As Long = &H10000
Public Const EVT_CRW_ALL                    As Long = &HFFFFFFFF

' DLL-API `錾

'VA|[g񋓊֐
Declare Function crwGetPortNames Lib "PCardRW32.dll" (ByRef strPortNames As String, _
                                                      ByRef iNumOfPort As Integer _
                                                      ) As Long

'COM|[g擾֐
Declare Function crwGetComDevInfo Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                        ByRef bpDriveDesc As String, _
                                                        ByRef bpProviderName As String, _
                                                        ByRef bpDriveDate As String, _
                                                        ByRef bpDriveVersion As String _
                                                        ) As Long
'ʐMDSRCTSMĎݒ֐
Declare Function crwComDSRCTSsw Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                    ByVal iDSRCheck As Integer, _
                                                    ByVal iCTSCheck As Integer _
                                                    ) As Integer

' |[gI[v֐
Declare Function crwOpenPort Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                  ByVal lBoudRate As Long, _
                                                  ByVal strDataBit As String, _
                                                  ByVal strPality As String _
                                                  ) As Integer
                                                     
' |[gN[Y֐
Declare Function crwClosePort Lib "PCardRW32.dll" (ByVal iPortNo As Integer) As Integer

'R}hM֐
Declare Function crwSendCommand Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                     ByVal lTimeOut As Long, _
                                                     ByVal iDSRCheck As Integer, _
                                                     ByVal strCommandCode As String, _
                                                     ByVal strCommandParameter As String, _
                                                     ByVal iParameterLength As Integer _
                                                     ) As Integer
                                                        
'f[^M֐()
Declare Function crwSendDataWR Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                    ByVal lTimeOut As Long, _
                                                    ByVal iDSRCheck As Integer, _
                                                    ByVal strData As String, _
                                                    ByVal iDataLength As Integer _
                                                    ) As Integer
                                                     
'f[^M֐(Ȃ)
Declare Function crwSendDataQR Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                    ByVal lTimeOut As Long, _
                                                    ByVal iDSRCheck As Integer, _
                                                    ByVal strData As String, _
                                                    ByVal iDataLength As Integer _
                                                    ) As Integer

'X|XM֐
Declare Function crwReceiveResponse Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                         ByVal iRecMode As Integer, _
                                                         ByVal lTimeOut As Long, _
                                                         ByVal iDSRCheck As Integer, _
                                                         ByRef strCOMSTS As String, _
                                                         ByRef strERRSEN As String, _
                                                         ByRef strResDATA As String _
                                                         ) As Integer

'f[^M֐
Declare Function crwReceiveData Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                     ByVal iDSRCheck As Integer, _
                                                     ByRef strResDATA As String, _
                                                     ByRef iDataLength As Integer _
                                                     ) As Integer

'f[^M֐(STX--ETX+BCC >><<)
Declare Function crwSendDataRR Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                    ByVal iRetryCount As Integer, _
                                                    ByVal lTimeOut As Long, _
                                                    ByVal iDSRCheck As Integer, _
                                                    ByVal strData As String, _
                                                    ByVal iDataLength As Integer, _
                                                    ByRef strResDATA As String, _
                                                    ByRef iResDataLength As Integer _
                                                    ) As Integer

'f[^M֐(STX--ETX+BCC >> Send)
Declare Function crwSendDataBCC Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                    ByVal iACKCheck As Integer, _
                                                    ByVal iRetryCount As Integer, _
                                                    ByVal lTimeOut As Long, _
                                                    ByVal iDSRCheck As Integer, _
                                                    ByVal strData As String, _
                                                    ByVal iDataLength As Integer _
                                                    ) As Integer

'f[^M֐(STX--ETX+BCC << Receive)
Declare Function crwReceiveDataBCC Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                    ByVal iACKResponse As Integer, _
                                                    ByVal lTimeOut As Long, _
                                                    ByVal iDSRCheck As Integer, _
                                                    ByRef strResDATA As String, _
                                                    ByRef iResDataLength As Integer _
                                                    ) As Integer

'f[^M֐(STX--ETX+BCC) ISO15693 HF[_[C^[Ή
Declare Function crwReceiveDataBCCHF Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                    ByVal iACKJudge As Integer, _
                                                    ByVal lTimeOut As Long, _
                                                    ByVal iDSRCheck As Integer, _
                                                    ByRef strResResponseF As String, _
                                                    ByRef strResRespF As String, _
                                                    ByRef strResStatF As String, _
                                                    ByRef strResResponseS As String, _
                                                    ByRef strResRespS As String, _
                                                    ByRef strResStatS As String, _
                                                    ByRef strResDATA As String, _
                                                    ByRef iResDataLength As Integer _
                                                    ) As Integer
                                                  
' ʐMMobt@[NA[֐
Declare Function crwComRXBufferClear Lib "PCardRW32.dll" (ByVal iPortNo As Integer) As Integer

'UHFRFIDR}hM֐
Declare Function crwSendBinaryCommandRR Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                             ByVal lTimeOut As Long, _
                                                             ByVal iRetryCount As Integer, _
                                                             ByVal iDSRCheck As Integer, _
                                                             ByVal iCTSCheck As Integer, _
                                                             ByRef lpSendData As Any, _
                                                             ByVal iSendDataLength As Integer, _
                                                             ByVal pTimeOut As Long, _
                                                             ByRef lpReceiveData As Any, _
                                                             ByVal iReceiveDataLength As Integer, _
                                                             ByRef piDataLengthReceived As Integer _
                                                             ) As Integer

'UHFRFIDR}hM֐
Declare Function crwSendBinaryData Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                        ByVal lTimeOut As Long, _
                                                        ByVal iRetryCount As Integer, _
                                                        ByVal iDSRCheck As Integer, _
                                                        ByVal iCTSCheck As Integer, _
                                                        ByRef lpData As Any, _
                                                        ByVal iDataLength As Integer _
                                                        ) As Integer

'UHFRFIDR}hM֐
Declare Function crwReceiveBinaryReport Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                             ByVal lTimeOut As Long, _
                                                             ByVal iRetryCount As Integer, _
                                                             ByVal iDSRCheck As Integer, _
                                                             ByVal iCTSCheck As Integer, _
                                                             ByRef lpData As Any, _
                                                             ByVal iDataLength As Integer, _
                                                             ByRef piDataLength As Integer _
                                                             ) As Integer

'oCif[^M֐QR
Declare Function crwSendBinaryDataQR Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                          ByVal lTimeOut As Long, _
                                                          ByVal iDSRCheck As Integer, _
                                                          ByVal iCTSCheck As Integer, _
                                                          ByRef lpData As Any, _
                                                          ByVal iDataLength As Integer _
                                                          ) As Integer

'oCif[^M֐
Declare Function crwReceiveBinaryData Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                           ByVal lTimeOut As Long, _
                                                           ByVal iDSRCheck As Integer, _
                                                           ByRef lpData As Any, _
                                                           ByVal iDataLength As Integer, _
                                                           ByRef piDataLength As Integer _
                                                           ) As Integer

' R}hM֐
Declare Function crwSendCommandRR Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                       ByVal iRecMode As Integer, _
                                                       ByVal lTimeOut As Long, _
                                                       ByVal lBusyTimeOut As Long, _
                                                       ByVal iDSRCheck As Integer, _
                                                       ByVal lpCommandCode As String, _
                                                       ByVal lpCommandParameter As String, _
                                                       ByVal iParameterLength As Integer, _
                                                       ByRef bpCOMSTS As String, _
                                                       ByRef bpERRSEN As String, _
                                                       ByRef bpResDATA As String _
                                                       ) As Integer

' X|XMCxgnho^֐
Declare Function crwSetResponseEventProc Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                              ByVal iRecMode As Integer, _
                                                              ByVal lTimeOut As Long, _
                                                              ByVal pResponseEventProc As Long, _
                                                              ByVal pParam As Long, _
                                                              ByVal lEvent As Long _
                                                              ) As Integer

' oCif[^MCxgnho^֐
Declare Function crwSetReceiveBinaryEventProc Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                                   ByVal lTimeOut As Long, _
                                                                   ByVal pReceiveBinaryEventProc As Long, _
                                                                   ByVal pParam As Long, _
                                                                   ByVal lEvent As Long _
                                                                   ) As Integer
                                                                   
' df[^MCxgnho^֐
Declare Function crwSetReceiveDataBCCEventProc Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                                   ByVal iACKResponse As Integer, _
                                                                   ByVal lTimeOut As Long, _
                                                                   ByVal pReceiveBCCEventProc As Long, _
                                                                   ByVal pParam As Long, _
                                                                   ByVal lEvent As Long _
                                                                   ) As Integer

' ʐMCxgnho^֐
Declare Function crwSetCommEventProc Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                          ByVal pCommEventProc As Long, _
                                                          ByVal pParam As Long, _
                                                          ByVal lEvent As Long _
                                                          ) As Integer

' AutoHandshakeݒ֐
Declare Function crwSetHandshake Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                          ByVal iHandshake As Integer _
                                                          ) As Integer

' AutoHandshakeԎ擾֐
Declare Function crwGetHandshakeStatus Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                          ByRef piAutoHandshake As Integer _
                                                          ) As Integer

' MԎ擾֐
Declare Function crwGetLineStatus Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                          ByRef piCTSLine As Integer, _
                                                          ByRef piDSRLine As Integer, _
                                                          ByRef piRLSDLine As Integer _
                                                          ) As Integer

' M֐
Declare Function crwSetLineControl Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                          ByVal iDTRLine As Integer, _
                                                          ByVal iRTSLine As Integer, _
                                                          ByVal iBreakLine As Integer _
                                                          ) As Integer

'IB Image Data 쐬֐
Declare Function crwIBBinarySend Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                          ByVal iRetryCount As Integer, _
                                                          ByVal iDSRCheck As Integer, _
                                                          ByVal iCTSCheck As Integer, _
                                                          ByVal iWidth As Integer, _
                                                          ByVal iHeight As Integer, _
                                                          ByVal iStartX As Integer, _
                                                          ByVal lTimeOut As Long, _
                                                          ByVal lComBufferSize As Long, _
                                                          ByVal strPathFileName As String, _
                                                          ByRef bpCOMSTS As String, _
                                                          ByRef bpERRSEN As String _
                                                          ) As Integer
                                                          
'PI Image Data 쐬֐
Declare Function crwPIDataSend Lib "PCardRW32.dll" (ByVal iPortNo As Integer, _
                                                          ByVal iRetryCount As Integer, _
                                                          ByVal iDSRCheck As Integer, _
                                                          ByVal iCTSCheck As Integer, _
                                                          ByVal iWidth As Integer, _
                                                          ByVal iHeith As Integer, _
                                                          ByVal iStartX As Integer, _
                                                          ByVal iStartY As Integer, _
                                                          ByVal lTimeOut As Long, _
                                                          ByVal lComBufferSize As Long, _
                                                          ByVal strPathFileName As String, _
                                                          ByRef bpCOMSTS As String, _
                                                          ByRef bpERRSEN As String _
                                                          ) As Integer

' R[hϊ֐
Declare Function crwCharCodeConv Lib "PCardRW32.dll" (ByVal iConvMode As Integer, _
                                                        ByVal csQConvStr As String _
                                                        ) As String

' JIS/Shift-JISR[hϊ֐
Declare Function crwJISconvSJIS Lib "PCardRW32.dll" (ByVal iConvMode As Integer, _
                                                         ByVal csQConvStr As String _
                                                          ) As String

