///////////////////////////////////////////////////////////////////////////////
// Device		FCard Reader/Writer Device Communication Control Liblary
//
// File Name	FPCRW64.h
//
// Purpose		FVisual C++ 6 Header File
//
// Update		F2013.03.25	Panasonic System Networks Co.,Ltd.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _INC_PCRW64_H
#define _INC_PCRW64_H

#ifdef __cplusplus
extern "C" {
#endif

#include <windows.h>
#include <stdio.h>
#include <malloc.h>
#include <windef.h>
#include <wtypes.h>
#include <oleauto.h>

#define		DllImport	_declspec(dllimport)

// Call Back function type definition
typedef short int (CALLBACK *RES_EVENT_PROC)(short int, LONG, BSTR, short int, LPARAM);
typedef short int (CALLBACK *RECBCC_EVENT_PROC)(short int, LONG, BSTR, short int, LPARAM);
typedef short int (CALLBACK *COMM_EVENT_PROC)(short int, LONG, LONG, LPARAM);

// API Declaration
extern DllImport BOOL WINAPI crwGetPortNames(BSTR*, short int*);
extern DllImport BOOL WINAPI crwGetComDevInfo(short int, BSTR*, BSTR*, BSTR*, BSTR*);

extern DllImport short int WINAPI crwOpenPort(short int, LONG, LPCSTR, LPCSTR);
extern DllImport short int WINAPI crwClosePort(short int);
extern DllImport short int WINAPI crwComDSRCTSsw(short int, short int, short int);
	
extern DllImport short int WINAPI crwSendCommandRR(short int, short int, LONG, LONG, short int, LPCTSTR, LPCTSTR, short int, BSTR*, BSTR*, BSTR*);
extern DllImport short int WINAPI crwSendCommand(short int, LONG, short int, LPCSTR, LPCSTR, short int);
extern DllImport short int WINAPI crwReceiveResponse(short int,	short int, LONG, short int, BSTR*, BSTR*, BSTR*);
	
extern DllImport short int WINAPI crwSendDataWR(short int, LONG, short int, LPCSTR, short int);
extern DllImport short int WINAPI crwSendDataQR(short int, LONG, short int, LPCSTR, short int);
extern DllImport short int WINAPI crwReceiveData(short int,	short int, BSTR*, short int*);

extern DllImport short int WINAPI crwSendDataRR(short int, short int, LONG, short int, LPCSTR, short int, BSTR*, short int*);
extern DllImport short int WINAPI crwSendDataBCC(short int,	short int, short int, LONG, short int, LPCTSTR, short int);
extern DllImport short int WINAPI crwReceiveDataBCC(short int, short int, LONG, short int, BSTR*, short int*);
extern DllImport short int WINAPI crwComRXBufferClear(short int);

extern DllImport short int WINAPI crwSendBinaryDataQR(short int, LONG, short int, short int, LPCVOID, short int);
extern DllImport short int WINAPI crwReceiveBinaryData(short int, LONG, short int, LPVOID, short int, short int*);

extern DllImport short int WINAPI crwSetResponseEventProc(short int, short int, LONG, RES_EVENT_PROC, LPARAM, LONG);
extern DllImport short int WINAPI crwSetReceiveDataBCCEventProc(short int iACKResponse, LONG lTimeOut, RECBCC_EVENT_PROC pReceiveBCCEventProc, LPARAM pParam, LONG lEvent);
extern DllImport short int WINAPI crwSetCommEventProc(short int, COMM_EVENT_PROC, LPARAM, LONG);

extern DllImport short int WINAPI crwPIDataSend( short int, short int, short int, short int, short int, short int, LONG, LONG, LPCSTR, BSTR*, BSTR*);
extern DllImport short int WINAPI crwIBBinarySend( short int, short int, short int, short int, short int, short int, LONG, LONG, LPCSTR, BSTR*, BSTR*);

extern DllImport BSTR WINAPI crwCharCodeConv(short int, LPCTSTR); 
extern DllImport BSTR WINAPI crwJISconvSJIS(short int, LPCTSTR); 

// API Return Code Declaration
#define RET_CRW_SUCCESS				0
#define RET_CRW_ACK					0
#define RET_CRW_RESPONSE			0
#define RET_CRW_FAILURE				1
#define RET_CRW_NAK					1
#define RET_CRW_READY				1
#define RET_CRW_BUSY				2
#define RET_CRW_NAK_BINARY			2
#define RET_CRW_ERR_PARAM			100
#define RET_CRW_ERR_PORT			101
#define RET_CRW_ERR_RES_TIMEOUT		110
#define RET_CRW_ERR_CTS_TIMEOUT		111
#define RET_CRW_ERR_DSR				112
#define RET_CRW_ERR_DSR_TIMEOUT		112		// For a subordinate position interchangeable version

#define RET_CRW_ERR_BUSY_TIMEOUT	113
#define RET_CRW_ERR_BCC_RETRY		120
#define RET_CRW_ERR_BUFFEROVER		130
#define RET_CRW_ERR_BUSY			140
#define RET_CRW_ERR_COMM_WRITE		200
#define RET_CRW_ERR_COMM_READ		201

// Event Constant
#define		EVT_RSP_CRW_RESPONSE			0x00000001
#define		EVT_RSP_CRW_READY				0x00000002
#define		EVT_RSP_CRW_BUSY				0x00000004
#define		EVT_RSP_CRW_CANCELED			0x00000008
#define		EVT_RSP_CRW_ERR_RES_TIMEOUT		0x00000100
#define		EVT_RSP_CRW_ERR_CTS_TIMEOUT		0x00000200
#define		EVT_RSP_CRW_ERR_DSR				0x00000400
#define		EVT_RSP_CRW_ERR_BCC_RETRY		0x00000800
#define		EVT_RSP_CRW_ERR_COMM_WRITE		0x00001000
#define		EVT_RSP_CRW_ERR_COMM_READ		0x00002000
#define		EVT_RSP_CRW_ALL					0xFFFFFFFF

#define		EVT_BCC_CRW_RESPONSE			0x00000001
#define		EVT_BCC_CRW_CANCELED			0x00000008
#define		EVT_BCC_CRW_ERR_RES_TIMEOUT		0x00000100
#define		EVT_BCC_CRW_ERR_CTS_TIMEOUT		0x00000200
#define		EVT_BCC_CRW_ERR_DSR				0x00000400
#define		EVT_BCC_CRW_ERR_BCC_RETRY		0x00000800
#define		EVT_BCC_CRW_ERR_COMM_WRITE		0x00001000
#define		EVT_BCC_CRW_ERR_COMM_READ		0x00002000
#define		EVT_BIN_CRW_ALL					0xFFFFFFFF

#define		EVT_CRW_RXCHAR					0x00000001
#define		EVT_CRW_TXEMPTY					0x00000004
#define		EVT_CRW_ERR_FRAME				0x00000100
#define		EVT_CRW_ERR_OVERRUN				0x00000200
#define		EVT_CRW_ERR_PARITY				0x00000400
#define		EVT_CRW_CTS						0x00001000
#define		EVT_CRW_DSR						0x00002000
#define		EVT_CRW_RLSD					0x00004000
#define		EVT_CRW_BREAK					0x00008000
#define		EVT_CRW_RING					0x00010000
#define		EVT_CRW_ALL						0xFFFFFFFF

#ifdef __cplusplus
}
#endif


#endif /* _INC_PCRW64_H */