﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using System.Windows.Forms;
//--------------------------------------------------------------------------
//iniファイルクラス
//
//--------------------------------------------------------------------------

namespace CS_sample
{
    class classIniFile{
        //API宣言----------------------------------------------
        [DllImport("KERNEL32.DLL")]
        public static extern uint
          GetPrivateProfileString(
            string strSection,
            string strEntry, 
            string strDefault,
            StringBuilder sbfBuff,
            uint uitSize,
            string strFilNam);

        [DllImport("KERNEL32.DLL")]
        public static extern uint WritePrivateProfileString(
          string strSection,
          string strEntry,
          string strVal,
          string strFilNam);

        //読込みバッファサイズ
        private const int BUFF_LEN  = 256; //256文字
        //Iniファイル名
        private string m_strIniFilNam;

        //クラス作成------------------------------------------------
        // strFilNam : iniファイルのフルパス（省略可能）
        //             省略時：exeのフルパスを拡張子「.ini」変更
        public classIniFile()
        {
            string strFilNam = ".\\PCardRW64.ini";
                   m_strIniFilNam = strFilNam;
        }

        //読込み-----------------------------------------------------------
        // strSection : セクション
        // strEntry : パラメータ
        // strDefault : 初期値（省略可能）省略時 :""
        // 戻り値：パラメータの値
        public string ReadIni(string strSection, string strEntry,
                        string strDefault ) {
                            strDefault = "";   
            StringBuilder sb  = new StringBuilder(BUFF_LEN);
            UInt32 ret  = GetPrivateProfileString(strSection, strEntry,
                    strDefault,sb, Convert.ToUInt32(sb.Capacity),
                    m_strIniFilNam);
            return sb.ToString();
       }

        //書込み---------------------------------------------------------
        // strSection : セクション
        // strEntry : パラメータ
        // strVal：パラメータの値
        public void WriteIni(string strSection,
                        string strEntry, string strVal){
            WritePrivateProfileString(strSection, 
                        strEntry, strVal, m_strIniFilNam);
        }
    }
}

