﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace CS_sample
{

        #region コールバック関数デリゲート宣言
        /// <summary>レスポンス受信イベントハンドラ登録 コールバック関数デリゲート宣言 
        /// レスポンス受信イベントハンドラ登録 コールバック関数デリゲート宣言
        /// </summary> 
        public delegate int CallBack(
                                        short iPortNo,
                                        int lEvent,
                                        [MarshalAs(UnmanagedType.BStr)] String lpData,
                                        short iDataLength,
                                        int pParam
                                     );

        /// <summary>電文データ受信イベントハンドラ登録 コールバック関数デリゲート宣言 
        /// 電文データ受信イベントハンドラ登録 コールバック関数デリゲート宣言
        /// </summary> 
        public delegate int CallBack2(
                                        short iPortNo,
                                        int lEvent,
                                        [MarshalAs(UnmanagedType.BStr)] String lpData,
                                        short iDataLength,
                                        int pParam
                                     );
        /// <summary>通信イベントハンドラ登録 コールバック関数デリゲート宣言 
        /// 通信イベントハンドラ登録 コールバック関数デリゲート宣言
        /// </summary> 
        public delegate int CallBack3(
                                        short iPortNo,
                                        int lBufferLength,
                                        int lEvent,
                                        int pParam
                                     );

        #endregion
    
    public partial class Form1 : Form
    {
        #region 定数定義
        /// <summary> 
        /// コールバック変数定義（クラスのメンバ変数）
        /// コールバック関数登録後に、ガベージコレクタにてデリゲートを開放されないように、
        /// グラスのメンバ変数として定義
        /// </summary> 
        CallBack myCallBack;    // レスポンス受信イベントハンドラ登録 コールバック関数デリゲート
        CallBack3 myCallBack3;  // 通信イベントハンドラ登録 コールバック関数デリゲート
        
        private Worker myWorker1;   // ワーカスレッド１
        private Worker myWorker2;   // ワーカスレッド２
        private Worker myWorker3;   // ワーカスレッド３

        static public bool[] portflag  = new bool[256];     // 開いたポート番号を追加
        static public int portcount = 0;                    // 開いたポート番号の数

        /// <summary>グローバル変数(擬似)
        /// </summary> 
        static public byte[] CommEventFlag = new byte[256];  // グローバル変数の宣言

        /// <summary>
        /// 定数定義
        /// </summary>  
        public const uint EVT_RSP_CRW_RESPONSE = 0x1;
        public const uint EVT_RSP_CRW_READY = 0x2;
        public const uint EVT_RSP_CRW_BUSY = 0x4;
        public const uint EVT_RSP_CRW_CANCELED = 0x8;
        public const uint EVT_RSP_CRW_ERR_RES_TIMEOUT = 0x100;
        public const uint EVT_RSP_CRW_ERR_CTS_TIMEOUT = 0x200;
        public const uint EVT_RSP_CRW_ERR_DSR = 0x400;
        public const uint EVT_RSP_CRW_ERR_BCC_RETRY = 0x800;
        public const uint EVT_RSP_CRW_ERR_COMM_WRITE = 0x1000;
        public const uint EVT_RSP_CRW_ERR_COMM_READ = 0x2000;
        public const uint EVT_RSP_CRW_ALL = 0xFFFFFFFF;

        public const uint EVT_BCC_CRW_RESPONSE = 0x1;
        public const uint EVT_BCC_CRW_CANCELED = 0x8;
        public const uint EVT_BCC_CRW_ERR_RES_TIMEOUT = 0x100;
        public const uint EVT_BCC_CRW_ERR_CTS_TIMEOUT = 0x200;
        public const uint EVT_BCC_CRW_ERR_DSR = 0x400;
        public const uint EVT_BCC_CRW_ERR_BCC_RETRY = 0x800;
        public const uint EVT_BCC_CRW_ERR_COMM_WRITE = 0x1000;
        public const uint EVT_BCC_CRW_ERR_COMM_READ = 0x2000;
        public const uint EVT_BCC_CRW_ALL = 0xFFFFFFFF;

        public const uint EVT_CRW_RXCHAR = 0x1;
        public const uint EVT_CRW_TXEMPTY = 0x4;
        public const uint EVT_CRW_ERR_FRAME = 0x100;
        public const uint EVT_CRW_ERR_OVERRUN = 0x200;
        public const uint EVT_CRW_ERR_PARITY = 0x400;
        public const uint EVT_CRW_CTS = 0x1000;
        public const uint EVT_CRW_DSR = 0x2000;
        public const uint EVT_CRW_RLSD = 0x4000;
        public const uint EVT_CRW_BREAK = 0x8000;
        public const uint EVT_CRW_RING = 0x10000;
        public const uint EVT_CRW_ALL = 0xFFFFFFFF;

        public const uint RET_CRW_SUCCESS = 0;
        public const uint RET_CRW_ACK = 0;
        public const uint RET_CRW_RESPONSE = 0;
        public const uint RET_CRW_FAILURE = 1;
        public const uint RET_CRW_NAK = 1;
        public const uint RET_CRW_READY = 1;
        public const uint RET_CRW_BUSY = 2;

        public const uint RET_CRW_ERR_PARAM = 100;
        public const uint RET_CRW_ERR_PORT = 101;
        public const uint RET_CRW_ERR_RES_TIMEOUT = 110;
        public const uint RET_CRW_ERR_CTS_TIMEOUT = 111;
        public const uint RET_CRW_ERR_DSR = 112;
        // 下位バージョンとの互換性の為
        public const uint RET_CRW_ERR_DSR_TIMEOUT = 112;
        public const uint RET_CRW_ERR_BUSY_TIMEOUT = 113;
        public const uint RET_CRW_ERR_BCC_RETRY = 120;
        public const uint RET_CRW_ERR_BUFFEROVER = 130;
        public const uint RET_CRW_ERR_BUSY = 140;

        public const uint RET_CRW_ERR_COMM_WRITE = 200;
        public const uint RET_CRW_ERR_COMM_READ = 201;
        #endregion

        #region PCardRW64.DLL参照定義

        #region シリアルポート名取得関数 crwGetPortNames()
        /// <summary>
        /// シリアルポート名取得関数 crwGetPortNames()
        /// </summary>
        /// <param name="bpPortNames">使用可能なシリアルポート名をCSV形式で返却するポインタ</param>
        /// <param name="piNumOfPort">使用可能なシリアルポートの数を返却するポインタ</param>
        /// <returns>ブール型, 論理型(Boolean)<</returns>
        [DllImport("PCardRW64.dll")]
        static extern bool crwGetPortNames(
                                         ref System.IntPtr bpPortNames,
                                         ref short piNumOfPort);
        #endregion

        #region ＣＯＭポート情報取得関数 crwGetComDevInfo()
        /// <summary>
        /// ＣＯＭポート情報取得関数 crwGetComDevInfo()
        /// </summary>
        /// <param name="iPortNo">取得したいシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="bpDriveDesc">シリアルポートのディスクリプター名を返却するエリアのポインタ</param>
        /// <param name="bpProviderName">シリアルポートドライバーのプロバイダーを返却するエリアのポインタ</param>
        /// <param name="bpDriverDate">シリアルポートドライバーの日付を返却するエリアのポインタ</param>
        /// <param name="bpDriverVersion">シリアルポートドライバーのバージョンを返却するエリアのポインタ</param>
        /// <returns>ブール型, 論理型(Boolean)</returns>        
        [DllImport("PCardRW64.dll")]
        static extern bool crwGetComDevInfo(
                                         short iPortNo,
                                         ref System.IntPtr bpDriveDesc,                                         
                                         ref System.IntPtr bpProviderName,
                                         ref System.IntPtr bpDriverDate,
                                         ref System.IntPtr bpDriverVersion);
        #endregion

        #region ポートオープン関数 crwOpenPort()
        /// <summary>
        /// ポートオープン関数 crwOpenPort()
        /// </summary>
        /// <param name="iPortNo">オープンするシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="lBaudRate">シリアルポートの通信速度（2400、4800、9600、19200、38400、57600、115200）</param>
        /// <param name="lpDataBit">シリアルポートのデータビット長（7または8）</param>
        /// <param name="piNumOfPort">シリアルポートのパリティチェック（ N：なし ／ E：偶数 ／ O：奇数）</param>
        /// <returns>整数型(short)</returns>   
        [DllImport("PCardRW64.dll")]
        unsafe static extern short crwOpenPort(
                                         short iPortNo, 
                                         uint lBaudRate, 
                                         char * lpDataBit, 
                                         char * lpParity);
        #endregion

        #region ポートクローズ関数 crwClosePort()
        /// <summary>
        /// ポートクローズ関数 crwClosePort()
        /// </summary>
        /// <param name="iPortNo">クローズするシリアルポートの番号（例：COM1なら”1”）</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        static extern short crwClosePort(short iPortNo);
        #endregion

        #region コマンド送受信関数 crwSendCommandRR() 
        /// <summary>
        /// コマンド送受信関数 crwSendCommandRR() 
        /// </summary>
        /// <param name="iPortNo">送信するシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="iRecMode">ビジーステータス受信の時にポーリング再送を行なうかどうかのフラグ（0以外：する / 0：しない）</param>
        /// <param name="lTimeOut">ACK/NAK待ち及びCTSオン待ちタイマー値（単位：msec）</param>
        /// <param name="lBusyTimeOut">ビジーステータスの終了待ちタイマー値（単位：msec）</param>
        /// <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ　（0:しない／0以外:する）</param>
        /// <param name="lpCommandCode">機器のコマンドコード（2バイト）</param>
        /// <param name="lpCommandParameter">機器のコマンドのパラメータ(パラメータ無しの時はNull)</param>
        /// <param name="iParameterLength">コマンドパラメータの長さ</param>
        /// <param name="bpCOMSTS">レスポンスのコマンドコード(=COM$)・レディステータスのステータス情報(=STS$)を返却するエリアのポインタ（2バイト）</param>
        /// <param name="bpERRSEN">レスポンスのエラーコード(=ERR$)・レディステータスのセンサー情報(=SEN$)を返却するエリアのポインタ（2バイト）</param>
        /// <param name="bpResDATA">レスポンスのデータ部分(=DATA$)を返却するエリアのポインタ(センサー情報以外の追加情報がある場合は、以降の情報は“bpResDATA”に格納される)</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        static extern short crwSendCommandRR(
                                         short  iPortNo,
                                         short  iRecMode,
                                         uint lTimeOut,
                                         uint lBusyTimeOut,
                                         short iDSRCheck,
                                         string lpCommandCode,
                                         string lpCommandParameter,
                                         short  iParameterLength,
                                         ref System.IntPtr bpCOMSTS,
                                         ref System.IntPtr bpERRSEN,
                                         ref System.IntPtr bpResDATA);
        #endregion

        #region コマンド送信関数 crwSendCommand()
        /// <summary>
        /// コマンド送信関数 crwSendCommand()
        /// </summary>
        /// <param name="iPortNo">コマンドを送信するシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="lTimeOut">ACK/NAK待ち及びCTSオン待ちタイマー値（単位：msec）</param>
        /// <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外：する / 0：しない）</param>
        /// <param name="lpCommandCode">機器のコマンドコード（2バイト）</param>
        /// <param name="lpCommandParameter">機器のコマンドのパラメータ（パラメータ無しの時はNULL）</param>
        /// <param name="iParameterLength">コマンドパラメータの長さ</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        static extern short crwSendCommand(
                                         short iPortNo,
                                         uint lTimeOut,
                                         short iDSRCheck,
                                         string lpCommandCode,
                                         string lpCommandParameter,
                                         short iParameterLength);
        #endregion

        #region レスポンス受信関数  crwReceiveResponse()
        /// <summary>
        /// レスポンス受信関数  crwReceiveResponse()
        /// </summary>
        /// <param name="iPortNo">レスポンスを受信するシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="iRecMode">ビジーステータス受信時にポーリング再送を行うかどうかのフラグ</param>
        /// <param name="lTimeOut">ポーリングに対する機器からの応答待ちタイマー値（単位：msec）</param>
        /// <param name="iDSRCheck">DSR信号線のチェックを行うかどうかのフラグ（0以外：する / 0：しない）</param>
        /// <param name="bpCOMSTS">ステータス情報、またはコマンドコードを返却するエリアのポインタ（2バイト）</param>
        /// <param name="bpERRSEN">センサー情報、またはエラーコードを返却するエリアのポインタ（2バイト）</param>
        /// <param name="bpResDATA">レスポンスのデータ部分(=DATA$)を返却するエリアのポインタ(センサー情報以外の追加情報がある場合は、以降の情報は“bpResDATA”に格納される)</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        static extern short crwReceiveResponse(
                                         short iPortNo,
                                         short iRecMode,
                                         uint lTimeOut,
                                         short iDSRCheck,
                                         ref System.IntPtr bpCOMSTS,
                                         ref System.IntPtr bpERRSEN,
                                         ref System.IntPtr bpResDATA);
        #endregion

        #region データ送信関数（応答あり）crwSendDataWR()
        /// <summary>
        /// データ送信関数（応答あり）crwSendDataWR()
        /// </summary>
        /// <param name="iPortNo">データを送信するシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="lTimeOut">ACK/NAK待ち及びCTSオン待ちタイマー値（単位：msec）</param>
        /// <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外：する / 0：しない）</param>
        /// <param name="lpData">送信するデータ</param>
        /// <param name="iDataLength">送信するデータの長さ</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        static extern short crwSendDataWR(
                                         short iPortNo,
                                         uint lTimeOut,
                                         short iDSRCheck,
                                         string lpData,
                                         short iDataLength);
        #endregion

        #region データ送信関数（応答なし） crwSendDataQR()
        /// <summary>
        /// データ送信関数（応答なし） crwSendDataQR()
        /// </summary>
        /// <param name="iPortNo">データを送信するシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="lTimeOut">ACK/NAK待ち及びCTSオン待ちタイマー値（単位：msec）</param>
        /// <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外：する / 0：しない）</param>
        /// <param name="lpData">送信するデータ</param>
        /// <param name="iDataLength">送信するデータの長さ</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        static extern short crwSendDataQR(
                                         short iPortNo,
                                         uint lTimeOut,
                                         short iDSRCheck,
                                         string lpData,
                                         short iDataLength);
        #endregion

        #region データ受信関数 crwReceiveData()
        /// <summary>
        /// データ受信関数 crwReceiveData()
        /// </summary>
        /// <param name="iPortNo">受信するシリアルポートの番号</param>
        /// <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外:する / 0:しない）</param>
        /// <param name="bpResDATA">レスポンスのデータ部分を返却するエリアのポインタ</param>
        /// <param name="iDataLength">受信したデータの長さ</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        static extern short crwReceiveData(
                                         short iPortNo,
                                         short iDSRCheck,
                                         ref System.IntPtr bpResDATA,
                                         ref short iDataLength);
        #endregion

        #region 電文データ送受信関数 crwSendDataRR()
        /// <summary>
        /// 電文データ送受信関数 crwSendDataRR()
        /// </summary>
        /// <param name="iPortNo">送受信するシリアルポート番号</param>
        /// <param name="iRetryCount">データ送信・応答データ受信タイムアウト時のリトライ回数</param>
        /// <param name="lTimeOut">リトライ時の待ち時間（単位:msec）</param>
        /// <param name="iDSRCheck">信号線をチェックするかどうかのフラグ（0以外:する / 0:しない）</param>
        /// <param name="lpData">送信するデータ</param>
        /// <param name="iDataLength">送信するデータの長さ</param>
        /// <param name="bpResDATA">レスポンスのデータ部分を返却するエリアポインタ</param>
        /// <param name="piDataLength">受信したデータの長さ</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        unsafe static extern short crwSendDataRR(
                                                    short iPortNo,
                                                    short iRetryCount,
                                                    uint lTimeOut,
                                                    short iDSRCheck,
                                                    string lpData,
                                                    short iDataLength,
                                                    ref System.IntPtr bpResDATA,
                                                    ref short piDataLength);
        #endregion

        #region 電文データ送信関数 crwSendDataBCC()
        /// <summary>
        /// 電文データ送信関数 crwSendDataBCC()
        /// </summary>
        /// <param name="iPortNo">データを送信するシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="iACKCheck">ACK/NAKを待つかどうかのフラグ（0以外：する / 0：しない）</param>
        /// <param name="iRetryCount">データ送信・ACK/NAK受信タイムアウト時のリトライ回数</param>
        /// <param name="lTimeOut">ACK/NAK待ち及びCTS ON待ちタイマー（単位:msec）(IACKCheck=0のときはACK/NAK待ちタイマーのみ無効)</param>
        /// <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外：する / 0：しない）</param>
        /// <param name="lpData">送信するデータ</param>
        /// <param name="iDataLength">送信するデータの長さ</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        unsafe static extern short crwSendDataBCC(
                                                    short iPortNo,
                                                    short iACKCheck,
                                                    short iRetryCount,
                                                    uint lTimeOut,
                                                    short iDSRCheck,
                                                    string lpData,
                                                    short iDataLength);
        #endregion

        #region 電文データ受信関数 crwReceiveDataBCC()
        /// <summary>
        /// 電文データ受信関数 crwReceiveDataBCC()
        /// </summary>
        /// <param name="iPortNo">レスポンスを受信するシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="iACKResponse">ACK/NAKを返却するかどうかのフラグ（0以外：する / 0：しない）</param>
        /// <param name="lTimeOut">CTS ON待ちタイマー（単位:msec）   / iACKResponse =0のときは無効</param>
        /// <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外:する / 0:しない）</param>
        /// <param name="bpResDATA">レスポンスのデータ部分を返却するエリアのポインタ</param>
        /// <param name="piDataLength">受信したデータの長さ</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        unsafe static extern short crwReceiveDataBCC(
                                                    short iPortNo,
                                                    short iACKResponse,
                                                    uint lTimeOut,
                                                    short iDSRCheck,
                                                    ref System.IntPtr bpResDATA,
                                                    ref short piDataLength);
        #endregion

        #region 受信バッファークリア関数 crwComRXBufferClear()
        /// <summary>
        /// 受信バッファークリア関数 crwComRXBufferClear()
        /// </summary>
        /// <param name="iPortNo">受信バッファーをクリアするシリアルポートの番号（例：COM1なら”1”）</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        static extern short crwComRXBufferClear(
                                         short iPortNo);
        #endregion
        
        #region バイナリデータ送信関数 crwSendBinaryDataQR()
        /// <summary>
        /// バイナリデータ送信関数 crwSendBinaryDataQR() 
        /// </summary>
        /// <param name="iPortNo">シリアルポートの番号</param>
        /// <param name="lTimeOut">CTSオン待ちタイマー値（単位：msec）</param>
        /// <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0：しない／0以外：する）</param>
        /// <param name="iCTSCheck">CTS信号線をチェックするかどうかのフラグ（0：しない／0以外：する）</param>
        /// <param name="lpData">送信するデータ</param>
        /// <param name="iDataLength">送信するデータの長さ</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        unsafe static extern short crwSendBinaryDataQR(
                                         short iPortNo,
                                         uint  lTimeOut,
                                         short iDSRCheck,
                                         short iCTSCheck,
                                         void* lpData,
                                         short iDataLength);
        #endregion

        #region バイナリデータ受信関数 crwReceiveBinaryData()
        /// <summary>
        /// バイナリデータ受信関数 crwReceiveBinaryData() 
        /// </summary>
        /// <param name="iPortNo">受信するシリアルポートの番号</param>
        /// <param name="lTimeOut">データの受信待ちタイマー値（単位：msec）</param>
        /// <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0：しない／0以外：する）</param>
        /// <param name="lpData">受信データを返却するエリアのポインタ</param>
        /// <param name="iDataLength">受信データを返却するエリアのサイズ</param>
        /// <param name="piDataLength">受信したデータの長さ</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        unsafe static extern short crwReceiveBinaryData(
                                         short iPortNo,
                                         uint lTimeOut,
                                         short iDSRCheck,
                                         void* lpData,
                                         short iDataLength,
                                         ref short piDataLength);
        #endregion
        
        #region レスポンス受信イベントハンドラ登録関数 crwSetResponseEventProc()
        /// <summary>
        /// レスポンス受信イベントハンドラ登録関数 crwSetResponseEventProc() 
        /// </summary>
        /// <param name="iPortNo">受信するシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="iRecMode">ビジーステータス受信時にポーリング再送を行うかどうかのフラグ（0以外：する / 0：しない）</param>
        /// <param name="lTimeOut">データの受信待ちタイマー値(単位:msec) （0 msec指定で無限待ち）</param>
        /// <param name="pResponseEventProc">crwResponseEventProc関数のポインタ(NULLを指定:登録解除)</param>
        /// <param name="lParam">アプリケーションによって定義された値</param>
        /// <param name="lEvent">コールバック関数で受け取るイベントの論理和</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        unsafe static extern short crwSetResponseEventProc(
                                         short iPortNo,
                                         short iRecMode,
                                         uint lTimeOut,
                                         CallBack pResponseEventProc,
                                         int lParam,
                                         uint lEvent);
        #endregion

        #region 電文データ受信イベントハンドラ登録関数 crwSetReceiveDataBCCEventProc()
        /// <summary>
        /// 電文データ受信イベントハンドラ登録関数 crwSetReceiveDataBCCEventProc() 
        /// </summary>
        /// <param name="iPortNo">受信するシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="iACKResponce">ACK/NAKを返却するかどうかのフラグ（0以外：する / 0：しない）</param>
        /// <param name="lTimeOut">データの受信待ちタイマー値(単位:msec) （0 msec指定で無限待ち）</param>
        /// <param name="pReceiveBCCEventProc">crwSetReceiveDataBCCEventProc関数のポインタ(NULLを指定:登録解除)</param>
        /// <param name="lParam">アプリケーションによって定義された値</param>
        /// <param name="lEvent">コールバック関数で受け取るイベントの論理和</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        unsafe static extern short crwSetReceiveDataBCCEventProc(
                                         short iPortNo,
                                         short iACKResponce,
                                         uint lTimeOut,
                                         CallBack2 pReceiveBCCEventProc,
                                         int lParam,
                                         uint lEvent);
        #endregion

        #region 通信イベントハンドラ登録関数 crwSetCommEventProc()
        /// <summary>
        /// 通信イベントハンドラ登録関数 crwSetCommEventProc()
        /// </summary>
        /// <param name="iPortNo">監視するシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="pCommEventProc">crwCommEventProc関数のポインタ(NULLを指定:登録解除)</param>
        /// <param name="pParam">アプリケーションによって定義された値</param>
        /// <param name="lEvent">コールバック関数で受け取るイベントの論理和</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        public static extern short crwSetCommEventProc(
                                         short iPortNo,
                                         CallBack3 pCommEventProc,
                                         int pParam,
                                         uint lEvent);
        #endregion

        #region 通信中DSR/CTS信号監視設定関数 crwComDSRCTSsw()
        /// <summary>
        /// 通信中DSR/CTS信号監視設定関数 crwComDSRCTSsw()
        /// </summary>
        /// <param name="iPortNo">DSR・CTSフローを監視するシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="iDSRCheck">通信中のDSR信号線をチェックするかどうかのフラグ（0:しない／0以外:する）初期値：0以外:する</param>
        /// <param name="iCTSCheck">通信中のCTS信号線をチェックするかどうかのフラグ（0:しない／0以外:する）初期値：0以外:する</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW64.dll")]
        unsafe static extern short crwComDSRCTSsw(
                                         short iPortNo,
                                         short iDSRCheck,
                                         short iCTSCheck);
        #endregion

        #region BSTR変換 SysAllocStringByteLen(),SysStringByteLen(),lstrlenA()
        /// <summary>
        /// BSTR変換 SysAllocStringByteLen(),SysStringByteLen(),lstrlenA()
        /// </summary>
        [DllImport("OleAut32.dll", CharSet=CharSet.Ansi, ExactSpelling=true)]
        public static extern IntPtr SysAllocStringByteLen(string sz, Int32 len);
        [DllImport("OleAut32.dll", CharSet=CharSet.Ansi, ExactSpelling=true)]
        public static extern Int32 SysStringByteLen(IntPtr bstr);
        [DllImport("Kernel32.dll", CharSet=CharSet.Ansi, ExactSpelling=true)]
        public static extern Int32 lstrlenA(string sz);

        #endregion

        #region PI Image Data 作成＆出力関数 crwPIDataSend()
        /// <summary>
        /// PI Image Data 作成＆出力関数 crwPIDataSend() 
        /// </summary>
        /// <param name="iPortNo">送信するシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="iRetryCount">データ送信、NAK 受信、及び SUNエラー受信時のリトライ回数</param>
        /// <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0：しない／0 以外：する）</param>
        /// <param name="iCTSCheck">CTS信号線をチェックするかどうかのフラグ（0：しない／0 以外：する）</param>
        /// <param name="iWidth">印字エリアの横幅（機器の仕様書参考）例：319</param>
        /// <param name="iHeigth">印字エリアの縦幅（機器の仕様書参考）例：459</param>
        /// <param name="iStartX">印字開始位置(X座標) 例：20</param>
        /// <param name="iStartY">印字開始位置(Y座標) 例：100</param>
        /// <param name="lTimeout">データの受信待ちタイマー値(単位:msec)</param>
        /// <param name="lComBufferSize">COMポート通信バッファーサイズ(機器の通信バッファーサイズ合わせてデータを作成し送信します)</param>
        /// <param name="strPathFileName">イメージデータファイル名[ BMP, JPG, GIF ] 形式（フルパス指定可能）</param>
        /// <param name="bpCOMSTS">レスポンスのコマンドコード(=COM$)・レディステータスのステータス情報(=STS$)を返却するエリアのポインタ（2バイト）</param>
        /// <param name="bpERRSEN">レスポンスのエラーコード(=ERR$)・レディステータスのセンサー情報(=SEN$)を返却するエリアのポインタ（2バイト）</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW32.dll")]
        static extern short crwPIDataSend(
                                            short iPortNo,
                                            short iRetryCount,
                                            short iDSRCheck,
                                            short iCTSCheck,
                                            short iWidth,
                                            short iHeigth,
                                            short iStartX,
                                            short iStartY,
                                            uint lTimeout,
                                            uint lComBufferSize,
                                            string strPathFileName,
                                            ref System.IntPtr bpCOMSTS,
                                            ref System.IntPtr bpERRSEN);
        #endregion

        #region IB Image Data 作成＆出力関数 crwIBBinarySend()
        /// <summary>
        /// PI Image Data 作成＆出力関数 crwPIDataSend() 
        /// </summary>
        /// <param name="iPortNo">送信するシリアルポートの番号（例：COM1なら”1”）</param>
        /// <param name="iRetryCount">データ送信、NAK 受信、及び SUNエラー受信時のリトライ回数</param>
        /// <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0：しない／0 以外：する）</param>
        /// <param name="iCTSCheck">CTS信号線をチェックするかどうかのフラグ（0：しない／0 以外：する）</param>
        /// <param name="iWidth">印字エリアの横幅（機器の仕様書参考）例：319</param>
        /// <param name="iHeigth">印字エリアの縦幅（機器の仕様書参考）例：459</param>
        /// <param name="iStartX">印字開始位置(X座標) 例：20</param>
        /// <param name="iStartY">印字開始位置(Y座標) 例：100</param>
        /// <param name="lTimeout">データの受信待ちタイマー値(単位:msec)</param>
        /// <param name="lComBufferSize">COMポート通信バッファーサイズ(機器の通信バッファーサイズ合わせてデータを作成し送信します)</param>
        /// <param name="strPathFileName">イメージデータファイル名[ BMP, JPG, GIF ] 形式（フルパス指定可能）</param>
        /// <param name="bpCOMSTS">レスポンスのコマンドコード(=COM$)・レディステータスのステータス情報(=STS$)を返却するエリアのポインタ（2バイト）</param>
        /// <param name="bpERRSEN">レスポンスのエラーコード(=ERR$)・レディステータスのセンサー情報(=SEN$)を返却するエリアのポインタ（2バイト）</param>
        /// <returns>整数型(short)</returns>
        [DllImport("PCardRW32.dll")]
        static extern short crwIBBinarySend(
                                            short iPortNo,
                                            short iRetryCount,
                                            short iDSRCheck,
                                            short iCTSCheck,
                                            short iWidth,
                                            short iHeigth,
                                            short iStartX,
                                            short iStartY,
                                            uint lTimeout,
                                            uint lComBufferSize,
                                            string strPathFileName,
                                            ref System.IntPtr bpCOMSTS,
                                            ref System.IntPtr bpERRSEN);

        #endregion

        #endregion

        #region From1初期ロード



        /// <summary>
        /// From1初期ロード



        /// </summar>y
        public Form1()
        {
            InitializeComponent();

            // Get App Version
            string strAppVer = System.Reflection.Assembly.GetEntryAssembly().GetName().Version.ToString();
            
            // Get File Version
            string FileVersion = "";
            if (!GetVerion("PCardRW64.dll", ref FileVersion))
            {
                FileVersion = " File Not Found !! ";
            }
            //this.Text = "PCardRW64.Dll 関数Test Program VB6 Ver:" + strAppVer +
            //    " [ DLL Ver:" & strDLLVer & " ]";
            this.Text = "PCardRW64.Dll 関数Test Program C#2008 Ver:" + strAppVer + " [ DLL Ver:" + FileVersion + " ]";

            // コンボボックス初期表示設定
            //ポート番号初期表示設定
            opPortNo.SelectedIndex = 0;
            scrPortNo.SelectedIndex = 0;
            scPortNo.SelectedIndex = 0;
            rrPortNo.SelectedIndex = 0;
            cpPortNo.SelectedIndex = 0;
            repPortNo.SelectedIndex = 0;
            sdPortNo.SelectedIndex = 0;
            rdPortNo.SelectedIndex = 0;
            sdrrPortNo.SelectedIndex = 0;
            sbdqPortNo.SelectedIndex = 0;
            rbdPortNo.SelectedIndex = 0;
            repPortNo.SelectedIndex = 0;
            cepPortNo.SelectedIndex = 0;
            sdbccPortNo.SelectedIndex = 0;
            rdbccPortNo.SelectedIndex = 0;

            // 通信速度初期表示設定
            opBaudRate.SelectedIndex = 2;
            
            // データ長初期表示設定
            opDataBit.SelectedIndex = 1;

            // パリティ初期表示設定
            opParity.SelectedIndex = 1;

            // crwSendDataQR 初期データ設定
            int len;
            sdData.Text = "\u0004" + "\u0005";
            len = sdData.TextLength;
            sdDatalen.Text = len.ToString();

            //CommEventFlagの初期化
            for(int x = 0;x < 256;x++){
                CommEventFlag[x] = 0;
            }

            myWorker1 = new Worker("Worker1");
            myWorker2 = new Worker("Worker2");
            myWorker3 = new Worker("Worker3");

            bool newmaking = false;

            // ファイルが存在するかどうか調べる
            string filedata;
            int index1 = 0, index2 = 0;
            string logvalue = "-1";
            System.IO.StreamReader sr;
            if (System.IO.File.Exists(@".\PCardRW64.ini"))
            {
                // ファイルが存在する場合ファイルを開きLogFileNameが一致するかどうか確認する      
                sr =
                    new System.IO.StreamReader(@".\PCardRW64.ini",
                        System.Text.Encoding.GetEncoding(932));     // Shift-JISコードとして開く
                filedata = sr.ReadToEnd();  // 内容をすべて読み込む
                sr.Close();

                // Nameから次のトークンの出現箇所を調べる
                lookuptoken("Name", filedata, ref index1, true);
                nexttoken(filedata, ref index1);

                // PCardRW64DLL INI Fileの出現箇所を調べる
                lookuptoken("PCardRW64DLL INI File", filedata, ref index2, false);

                if (index1 == index2)
                    // 一致する場合は現在あるファイルを読み込みその値を変更する
                    newmaking = false;
                else     
                    // ファイルのIDが一致しなかった時
                    newmaking = true;
            }
            else newmaking = true;          // ファイルが存在しない場合フラグを立てる



            // 新規作成、又は上書き保存(Shift JISで書き込む)
            if (newmaking == true)
            {
                System.IO.StreamWriter sw =
                    new System.IO.StreamWriter(@".\PCardRW64.ini",
                    false,
                    System.Text.Encoding.GetEncoding(932));
                sw.WriteLine("[Application]\r\n"
                             + "Name=PCardRW64DLL INI File\r\n"
                             + "[Log]\r\n"
                             + "Logging=-1\r\n"
                             + "LogFileName=.\\\\PCardRW64_%03d.log\r\n"
                             + "[Delay]\r\n"
                             + "Delay=0\r\n"
                             + "[TimeOut]\r\n"
                             + "WriteFileTimeOut=5000");
                sw.Close();
                logvalue = "-1";        // 初期値の"-1"を入れる。　Logging = "-1" > ログを取得しない。
            }
            else
            {
                // クラスの実体を生成する。
                classIniFile Ini = new classIniFile();

                logvalue = Ini.ReadIni("Log", "Logging", "");

            }

            switch(logvalue.Trim())
            {
              case "0":
                        CmbLog.SelectedIndex = 1; // 0:ﾛｸﾞﾌｧｲﾙを出力する。(ｴﾗｰと各情報)
                        break;
              case "1":
                        CmbLog.SelectedIndex = 2; // 1:ﾛｸﾞﾌｧｲﾙを出力する。(ｴﾗｰのみ)
                        break;
              case "2":
                        CmbLog.SelectedIndex = 3; // 2:ﾛｸﾞをﾒﾓﾘに出力する。(ｴﾗｰと各情報)
                        break;
              case "3":
                        CmbLog.SelectedIndex = 0; // 3:ﾛｸﾞをﾒﾓﾘに出力する。(ｴﾗｰのみ)
                        break;
              default:
                        CmbLog.SelectedIndex = 0; // -1:ﾛｸﾞﾌｧｲﾙを出力しない。
                        break;
            }

        }
        #endregion

        #region (1) シリアルポート名取得処理 crwGetPortNames()
        /// <summary>
        /// (1) シリアルポート名取得処理 crwGetPortNames()
        /// </summary>
        private void GetPortNames_Click(object sender, EventArgs e)
        {
            //bool ret;
            short piNumOfPort = 0;
            IntPtr bpPortNames;

            RefreshMsg();   // 処理結果 TextBox クリア
            PortNames.Clear();
            PortNames.Refresh();
            NumOfPort.Clear();
            NumOfPort.Refresh();

            bpPortNames = ConvertStringToAnsiBSTR(""); // BSTR初期化



            // ret = crwGetPortNames(ref bpPortNames, ref piNumOfPort); // ｼﾘｱﾙﾎﾟｰﾄ名取得関数実行


            this.CallCrwFunction(
                    new CrwGetPortNamesFunction(
                                     ref bpPortNames, ref piNumOfPort, crwGetPortNamesResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwGetPortNamesResultHandler(bool ret, IntPtr bpPortNames, short piNumOfPort);
        // 結果表示関数
        void crwGetPortNamesResult(bool ret, IntPtr bpPortNames, short piNumOfPort)
        {
            if (ret == true)
            {
                PortNames.Text = ConvertAnsiBSTRToString(bpPortNames); // ｼﾘｱﾙﾎﾟｰﾄ名設定


            
                NumOfPort.Text = piNumOfPort.ToString(); // ｼﾘｱﾙﾎﾟｰﾄ数設定


            
                label126.Text = "crwGetPortNames";
                RetVal.BackColor = Color.Green;
                RetVal.Text = "TRUE";
            }
            else
            {
                label126.Text = "crwGetPortNames";
                RetVal.BackColor = Color.Red;
                RetVal.Text = "FALSE";
            }
            
            Marshal.FreeBSTR(bpPortNames);  // BSTR開放
            //            RetVal.Text = ret.ToString();
            //            ErrMsg((uint)ret, "crwGetPortNames");
        }
        // 結果表示関数呼出し


        void crwGetPortNamesResultInvoker(CrwFunction crwFunction)
        {
            CrwGetPortNamesFunction f = (CrwGetPortNamesFunction)crwFunction;
            this.BeginInvoke(new CrwGetPortNamesResultHandler(crwGetPortNamesResult), new object[] { f._ret, f._bpPortNames, f._piNumOfPort });
        }
        #endregion

        #region (2) COMポート情報取得関数 crwGetComDevInfo()
        /// <summary>
        /// (2) COMポート情報取得関数 crwGetComDevInfo()
        /// </summary>
        private void GetComDevInfo_Click(object sender, EventArgs e)
        {
            //bool ret;
            short iPortNo;

            //string bpDriverDesc;
            //string bpProviderName;
            //string bpDriverDate;
            //string bpDriverVersion;

            IntPtr bpDriverDescBSTR;
            IntPtr bpProviderNameBSTR;
            IntPtr bpDriverDateBSTR;
            IntPtr bpDriverVersionBSTR;

            RefreshMsg();   // 処理結果 TextBox クリア
            LbComDevInfo_0.Text = "Desc    :";
            LbComDevInfo_1.Text = "Provider:";
            LbComDevInfo_2.Text = "Date    :";
            LbComDevInfo_3.Text = "Version :";

            iPortNo = short.Parse(opPortNo.Text);           // PortNo

            bpDriverDescBSTR = ConvertStringToAnsiBSTR(string.Empty);     // BSTR初期化



            bpProviderNameBSTR = ConvertStringToAnsiBSTR(string.Empty);   //
            bpDriverDateBSTR = ConvertStringToAnsiBSTR(string.Empty);     //
            bpDriverVersionBSTR = ConvertStringToAnsiBSTR(string.Empty);  //

            // レスポンス受信関数実行



            //ret = crwGetComDevInfo(
            //                iPortNo,
            //                ref bpDriverDescBSTR,
            //                ref bpProviderNameBSTR,
            //                ref bpDriverDateBSTR,
            //                ref bpDriverVersionBSTR
            //);
            this.CallCrwFunction(
                    new CrwGetComDevInfoFunction(
                            iPortNo,
                            ref bpDriverDescBSTR,
                            ref bpProviderNameBSTR,
                            ref bpDriverDateBSTR,
                            ref bpDriverVersionBSTR,
                            crwGetComDevInfoResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwGetComDevInfoResultHandler(
                bool ret,
                ref IntPtr bpDriverDescBSTR,
                ref IntPtr bpProviderNameBSTR,
                ref IntPtr bpDriverDateBSTR,
                ref IntPtr bpDriverVersionBSTR);
        // 結果表示関数
        void crwGetComDevInfoResult(
                bool ret,
                ref IntPtr bpDriverDescBSTR,
                ref IntPtr bpProviderNameBSTR,
                ref IntPtr bpDriverDateBSTR,
                ref IntPtr bpDriverVersionBSTR)
        {
            string bpDriverDesc;
            string bpProviderName;
            string bpDriverDate;
            string bpDriverVersion;

            // BSTR -> Stringへの変換
            bpDriverDesc = ConvertAnsiBSTRToString(bpDriverDescBSTR);
            bpProviderName = ConvertAnsiBSTRToString(bpProviderNameBSTR);
            bpDriverDate = ConvertAnsiBSTRToString(bpDriverDateBSTR);
            bpDriverVersion = ConvertAnsiBSTRToString(bpDriverVersionBSTR);

            // 関数実行結果を表示
            if ((bpDriverDesc != "") && (ret == true))
            {
                LbComDevInfo_0.Text = "Desc    :" + bpDriverDesc + "(COM" + opPortNo.Text + ")";
                toolTip1.SetToolTip(LbComDevInfo_0, bpDriverDesc + "(COM" + opPortNo.Text + ")");
                LbComDevInfo_1.Text = "Provider:" + bpProviderName;
                toolTip1.SetToolTip(LbComDevInfo_1, bpProviderName);
                LbComDevInfo_2.Text = "Date    :" + bpDriverDate;
                toolTip1.SetToolTip(LbComDevInfo_2, bpDriverDate);
                LbComDevInfo_3.Text = "Version :" + bpDriverVersion;
                toolTip1.SetToolTip(LbComDevInfo_3, bpDriverVersion);
            }

            // 確保した BSTR を開放します



            Marshal.FreeBSTR(bpDriverDescBSTR);
            Marshal.FreeBSTR(bpProviderNameBSTR);
            Marshal.FreeBSTR(bpDriverDateBSTR);
            Marshal.FreeBSTR(bpDriverVersionBSTR);

            if (ret == true)
            {
                label126.Text = "crwGetComDevInfo";
                RetVal.BackColor = Color.Green;
                RetVal.Text = "TRUE";
            }
            else
            {
                label126.Text = "crwGetComDevInfo";
                RetVal.BackColor = Color.Red;
                RetVal.Text = "FALSE";
            }

        }
        // 結果表示関数呼出し


        void crwGetComDevInfoResultInvoker(CrwFunction crwFunction)
        {
            CrwGetComDevInfoFunction f = (CrwGetComDevInfoFunction)crwFunction;
            this.BeginInvoke(
                    new CrwGetComDevInfoResultHandler(crwGetComDevInfoResult),
                    new object[] {
                            f._ret,
                            f._bpDriveDesc,
                            f._bpProviderName,
                            f._bpDriverDate,
                            f._bpDriverVersion
                    }
            );
        }
        #endregion

        #region (3) ポートオープン関数処理 crwOpenPort()
        /// <summary>
        /// (3) ポートオープン関数処理 crwOpenPort()
        /// </summary>
        unsafe private void OpenPort_Click(object sender, EventArgs e)
        {
            //short ret = 0;
            short portno;
            uint brate;
            char bit;
            char Parity;

            RefreshMsg();   // 処理結果 TextBox クリア

            portno = short.Parse(opPortNo.Text); // ポート番号
            brate = uint.Parse(opBaudRate.Text); // 通信速度

            switch (opDataBit.SelectedIndex)    // データ長
            {
                case 0:
                    bit = '7';  // 7bit指定
                    break;
                case 1:
                    bit = '8';  // 8bit指定
                    break;
                default:
                    bit = '8';  // 8bit指定
                    break;
            }

            switch (opParity.SelectedIndex) // パリティ
            {
                case 0:
                    Parity = 'N';   // パリティ無し 
                    break;
                case 1:
                    Parity = 'E';   // 偶数パリティ
                    break;
                case 2:
                    Parity = 'O';   // 奇数パリティ
                    break;
                default:
                    Parity = 'E';   // 偶数パリティ
                    break;
            }

            // ポートオープン関数実行
            //ret = crwOpenPort(portno, brate, &bit, &Parity);
            this.CallCrwFunction(
                    new CrwOpenPortFunction(
                              portno, brate, &bit, &Parity, crwOpenPortResultInvoker)
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwOpenPortResultHandler(short ret, short portno);
        // 結果表示関数
        void crwOpenPortResult(short ret, short portno)
        {
            if (ret == 0)
            {
                // ポートオープンが正常の場合、form1クラス全ての
                // ポート番号項目に設定
                scrPortNo.SelectedIndex = portno - 1;
                scPortNo.SelectedIndex = portno - 1;
                rrPortNo.SelectedIndex = portno - 1;
                cpPortNo.SelectedIndex = portno - 1;
                repPortNo.SelectedIndex = portno - 1;
                sdPortNo.SelectedIndex = portno - 1;
                rdPortNo.SelectedIndex = portno - 1;
                sdrrPortNo.SelectedIndex = portno - 1;
                sbdqPortNo.SelectedIndex = portno - 1;
                rbdPortNo.SelectedIndex = portno - 1;
                repPortNo.SelectedIndex = portno - 1;
                cepPortNo.SelectedIndex = portno - 1;
                sdbccPortNo.SelectedIndex = portno - 1;
                rdbccPortNo.SelectedIndex = portno - 1;
                crxbcPortNo.SelectedIndex = portno - 1;
                bccPortNo.SelectedIndex = portno - 1;
                pidsPortNo.SelectedIndex = portno - 1;
                ibbsPortNo.SelectedIndex = portno - 1;


                // フラグを立てる
                portflag[portno - 1] = true;
                portcount++;
            }

            // 処理結果の表示
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "crwOpenPort");

        }
        // 結果表示関数呼出し
        void crwOpenPortResultInvoker(CrwFunction crwFunction)
        {
            CrwOpenPortFunction f = (CrwOpenPortFunction)crwFunction;
            this.BeginInvoke(new CrwOpenPortResultHandler(crwOpenPortResult), new object[] { f._ret, f._iPortNo });
        }
        #endregion

        #region (4) ポートクローズ関数処理 crwClosePort()
        /// <summary>
        /// (4) ポートクローズ関数処理 crwClosePort()
        /// </summary>
        private void ClosePort_Click(object sender, EventArgs e)
        {
            //short ret = 0;
            short portno;

            RefreshMsg();   // 処理結果 TextBox クリア

            // ポート番号設定



            if (cpPortNo.SelectedIndex < 0)
                portno = 1;
            else
                portno = (short)(cpPortNo.SelectedIndex + 1);

            // ポートクローズ実行



            //ret = crwClosePort(portno);
            this.CallCrwFunction(
                    new CrwClosePortFunction(portno, crwClosePortResultInvoker)
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwClosePortResultHandler(short ret, short portno);
        // 結果表示関数
        void crwClosePortResult(short ret, short portno)
        {
            if (ret == 0)
            {
                CommEventFlag[portno - 1] = 0;  // 通信イベントハンドラ登録中設定


                portflag[portno - 1] = false;
                portcount--;
            }

            // 処理結果を表示
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "crwClosePort");

        }
        // 結果表示関数呼出し


        void crwClosePortResultInvoker(CrwFunction crwFunction)
        {
            CrwClosePortFunction f = (CrwClosePortFunction)crwFunction;
            this.BeginInvoke(new CrwClosePortResultHandler(crwClosePortResult), new object[] { f._ret, f._iPortNo });
        }
        #endregion

        #region (5) コマンド送受信関数処理 crwSendCommandRR()
        /// <summary>
        /// (5) コマンド送受信関数処理 crwSendCommandRR()
        /// </summary>
        private void SendCommandRR_Click(object sender, EventArgs e)
        {
            //short ret = 0;
            short iPortNo;
            short iRecMode;
            uint lTimeOut;
            uint lBusyTimeOut;
            short iDSRCheck;
            short iParameterLength;

            IntPtr bpCOMSTS;
            IntPtr bpERRSEN;
            IntPtr bpResDATA;

            RefreshMsg();   // 処理結果 TextBox クリア

            // 入力/参照項目(テキストボックス）の初期化



            scrCOMSTS.Clear(); 
            scrCOMSTS.Refresh();
            scrERRSEN.Clear();
            scrERRSEN.Refresh();
            scrResDATA.Clear();
            scrResDATA.Refresh();

            // ポート番号等の情報取得



            iPortNo = short.Parse(scrPortNo.Text);                  // PortNo
            iRecMode = short.Parse(scrRecMode.Text);                // RecMode
            lTimeOut = (uint)int.Parse(scrTimeOut.Text);            // TimeOut
            lBusyTimeOut = (uint)int.Parse(scrBusyTimeOut.Text);    // BusyTimeOut
            iDSRCheck = short.Parse(scrDSRCheck.Text);              // iDSRCheck

            string s = scrCmdCode.Text;             // lpCommandCode
            string t = scrCmdParam.SelectedText;    // lpCommandParameter

            iParameterLength = (short)scrCmdParam.TextLength;   // iParameterLength

            // BSTRの初期化



            bpCOMSTS = ConvertStringToAnsiBSTR("");     // BSTR型変数の初期化



            bpERRSEN = ConvertStringToAnsiBSTR("");     // 
            bpResDATA = ConvertStringToAnsiBSTR("");    // 

            //コマンド送受信関数実行



            //ret = crwSendCommandRR(
            //                iPortNo,
            //                iRecMode,
            //                lTimeOut,
            //                lBusyTimeOut,
            //                iDSRCheck,
            //                s,
            //                t,
            //                iParameterLength,
            //                ref bpCOMSTS,
            //                ref bpERRSEN,
            //                ref bpResDATA
            //);
            this.CallCrwFunction(
                    new CrwSendCommandRRFunction(
                            iPortNo,
                            iRecMode,
                            lTimeOut,
                            lBusyTimeOut,
                            iDSRCheck,
                            s,
                            t,
                            iParameterLength,
                            ref bpCOMSTS,
                            ref bpERRSEN,
                            ref bpResDATA,
                            crwSendCommandRRResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwSendCommandRRResultHandler(
                short ret,
                ref IntPtr bpCOMSTS,
                ref IntPtr bpERRSEN,
                ref IntPtr bpResDATA);
        // 結果表示関数
        void crwSendCommandRRResult(
                short ret,
                ref IntPtr bpCOMSTS,
                ref IntPtr bpERRSEN,
                ref IntPtr bpResDATA)
        {
            if (ret == 0)   // 結果が正常な場合



            {
                // 実行結果の表示
                scrCOMSTS.Text = ConvertAnsiBSTRToString(bpCOMSTS);
                scrERRSEN.Text = ConvertAnsiBSTRToString(bpERRSEN);
                scrResDATA.Text = ConvertAnsiBSTRToString(bpResDATA);
                toolTip1.SetToolTip(scrResDATA, scrResDATA.Text);
            }
            // 確保した BSTR を開放
            Marshal.FreeBSTR(bpCOMSTS);
            Marshal.FreeBSTR(bpERRSEN);
            Marshal.FreeBSTR(bpResDATA);

            // 処理結果の表示
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "crwSendCommandRR");
        }
        // 結果表示関数呼出し


        void crwSendCommandRRResultInvoker(CrwFunction crwFunction)
        {
            CrwSendCommandRRFunction f = (CrwSendCommandRRFunction)crwFunction;
            this.BeginInvoke(
                    new CrwSendCommandRRResultHandler(crwSendCommandRRResult),
                    new object[] {
                            f._ret,
                            f._bpCOMSTS,
                            f._bpERRSEN,
                            f._bpResDATA
                    }
            );
        }
        #endregion

        #region (6) コマンド送信関数処理 crwSendCommand()
        /// <summary>
        /// (6) コマンド送信関数処理 crwSendCommand()
        /// </summary>
        private void SendCommand_Click(object sender, EventArgs e)
        {
            //short ret = 0;
            short iPortNo;
            uint lTimeOut;
            short iDSRCheck;
            short iParameterLength;

            RefreshMsg();   // 処理結果 TextBox クリア

            iPortNo = short.Parse(scPortNo.Text);       // PortNo設定



            lTimeOut = (uint)int.Parse(scTimeOut.Text); // TimeOut設定



            iDSRCheck = short.Parse(scDSRCheck.Text);   // BusyTimeOut設定




            string s = scCmdCode.Text;  // lpCommandCode設定




            string t = scCmdParam.SelectedText; // lpCommandParameter設定




            iParameterLength = (short)scCmdParam.TextLength; // iParameterLength設定




            // コマンド送信関数実行



            //ret = crwSendCommand(
            //                        iPortNo,
            //                        lTimeOut,
            //                        iDSRCheck,
            //                        s,
            //                        t,
            //                        iParameterLength
            //                     );
            this.CallCrwFunction(
                    new CrwSendCommandFunction(
                                    iPortNo,
                                    lTimeOut,
                                    iDSRCheck,
                                    s,
                                    t,
                                    iParameterLength,
                                    crwSendCommandResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwSendCommandResultHandler(short ret);
        // 結果表示関数
        void crwSendCommandResult(short ret)
        {
            // 処理結果設定



            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "crwSendCommand");

            // レスポンス受信関数呼出指定の場合



            if (OpSendCommand1.Checked == true)
            {
                ReceiveResponse_Click(null, null);   // レスポンス受信関数呼出
            }// レスポンス受信イベントハンドラ登録関数呼出指定の場合



            else if (OpSendCommand2.Checked == true) 
            {
                SSTab1.SelectedTab = tabPage5;
                repEntry.Checked = true;
                SetResponseEventProc_Click(null, null); // レスポンス受信イベントハンドラ関数呼出
            }

        }
        // 結果表示関数呼出し


        void crwSendCommandResultInvoker(CrwFunction crwFunction)
        {
            CrwSendCommandFunction f = (CrwSendCommandFunction)crwFunction;
            this.BeginInvoke(new CrwSendCommandResultHandler(crwSendCommandResult), new object[] { f._ret });
        }
        #endregion

        #region (7) レスポンス受信関数処理 crwReceiveResponse()
        /// <summary>
        /// (7) レスポンス受信関数処理 crwReceiveResponse()
        /// </summary>
        private void ReceiveResponse_Click(object sender, EventArgs e)
        {
            //short ret = 0;
            short iPortNo;
            short iRecMode;
            uint lTimeOut;
            short iDSRCheck;

            IntPtr bpCOMSTS;
            IntPtr bpERRSEN;
            IntPtr bpResDATA;

            RefreshMsg();   // 処理結果 TextBox クリア
            rrCOMSTS.Clear();   // 各テキストボックスクリア
            rrCOMSTS.Refresh();
            rrERRSEN.Clear();
            rrERRSEN.Refresh();
            rrResDATA.Clear();
            rrResDATA.Refresh();

            iPortNo = short.Parse(rrPortNo.Text);        // PortNo
            iRecMode = short.Parse(rrRecMode.Text);      // RecMode
            lTimeOut = (uint)int.Parse(rrTimeOut.Text);  // TimeOut
            iDSRCheck = short.Parse(rrDSRCheck.Text);    // iDSRCheck

            bpCOMSTS = ConvertStringToAnsiBSTR("");  // BSTR初期化
            bpERRSEN = ConvertStringToAnsiBSTR("");  //
            bpResDATA = ConvertStringToAnsiBSTR(""); //

            // レスポンス受信関数実行



            //ret = crwReceiveResponse(
            //                iPortNo,
            //                iRecMode,
            //                lTimeOut,
            //                iDSRCheck,
            //                ref bpCOMSTS,
            //                ref bpERRSEN,
            //                ref bpResDATA
            //);
            this.CallCrwFunction(
                    new CrwReceiveResponseFunction(
                            iPortNo,
                            iRecMode,
                            lTimeOut,
                            iDSRCheck,
                            ref bpCOMSTS,
                            ref bpERRSEN,
                            ref bpResDATA,
                            crwReceiveResponseResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwReceiveResponseResultHandler(
                short ret,
                ref IntPtr bpCOMSTS,
                ref IntPtr bpERRSEN,
                ref IntPtr bpResDATA);
        // 結果表示関数
        void crwReceiveResponseResult(
                short ret,
                ref IntPtr bpCOMSTS,
                ref IntPtr bpERRSEN,
                ref IntPtr bpResDATA)
        {
            if ((ret == 0) || (ret == 1) || (ret == 2))  // Response / Ready / Busy
            {
                rrCOMSTS.Text = ConvertAnsiBSTRToString(bpCOMSTS);  // ｽﾃｰﾀｽ情報設定

                rrERRSEN.Text = ConvertAnsiBSTRToString(bpERRSEN);  // ｾﾝｻｰ情報設定

                rrResDATA.Text = ConvertAnsiBSTRToString(bpResDATA);// 受信ﾃﾞｰﾀ設定

                toolTip1.SetToolTip(rrResDATA, rrResDATA.Text);
            }

            // 確保した BSTR を開放します
            Marshal.FreeBSTR(bpCOMSTS);
            Marshal.FreeBSTR(bpERRSEN);
            Marshal.FreeBSTR(bpResDATA);

            // 処理結果表示
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "crwReceiveResponse");
        }
        // 結果表示関数呼出し


        void crwReceiveResponseResultInvoker(CrwFunction crwFunction)
        {
            CrwReceiveResponseFunction f = (CrwReceiveResponseFunction)crwFunction;
            this.BeginInvoke(
                    new CrwReceiveResponseResultHandler(crwReceiveResponseResult),
                    new object[] {
                            f._ret,
                            f._bpCOMSTS,
                            f._bpERRSEN,
                            f._bpResDATA
                    }
            );
        }
        #endregion

        #region (8) データ送信関数(応答あり)処理 crwSendDataWR()
        /// <summary>
        /// (8) データ送信関数(応答あり)処理 crwSendDataWR()
        /// </summary>
        private void SendDataWR_Click(object sender, EventArgs e)
        {
            short iPortNo;
            short iDSRCheck;
            uint lTimeOut;
            short iDataLength;

            RefreshMsg();   // 処理結果 TextBox クリア

            iPortNo = short.Parse(sdPortNo.Text);       // PortNo設定



            iDSRCheck = short.Parse(sdDSRCheck.Text);   // RecMode設定



            lTimeOut = (uint)int.Parse(sdTimeOut.Text); // TimeOut設定




            string s = sdData.Text;                 // 送信データ設定



            iDataLength = (short)sdData.TextLength; // 送信データ長設定




            // データ送信関数(応答あり)
            //ret = crwSendDataWR(
            //                     iPortNo,
            //                     lTimeOut,
            //                     iDSRCheck,
            //                     s,
            //                     iDataLength
            //                   );
            this.CallCrwFunction(
                    new CrwSendDataWRFunction(
                                 iPortNo,
                                 lTimeOut,
                                 iDSRCheck,
                                 s,
                                 iDataLength,
                                 crwSendDataWRResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwSendDataWRResultHandler(short ret);
        // 結果表示関数
        void crwSendDataWRResult(short ret)
        {
            RetVal.Text = ret.ToString();       // 処理結果設定



            ErrMsg((uint)ret, "crwSendDataWR");
        }
        // 結果表示関数呼出し


        void crwSendDataWRResultInvoker(CrwFunction crwFunction)
        {
            CrwSendDataWRFunction f = (CrwSendDataWRFunction)crwFunction;
            this.BeginInvoke(new CrwSendDataWRResultHandler(crwSendDataWRResult), new object[] { f._ret });
        }
        #endregion

        #region (9) データ送信関数(応答なし)処理 crwSendDataQR()
        /// <summary>
        /// (9) データ送信関数(応答なし)処理 crwSendDataQR()
        /// </summary>
        private void SendDataQR_Click(object sender, EventArgs e)
        {
            //short ret = 0;

            short iPortNo;
            short iDSRCheck;
            uint lTimeOut;
            short iDataLength;
            //int WaitTime;

            RefreshMsg();   // 処理結果 TextBox クリア

            iPortNo = short.Parse(sdPortNo.Text);       // PortNo設定



            iDSRCheck = short.Parse(sdDSRCheck.Text);   // RecMode設定



            lTimeOut = (uint)int.Parse(sdTimeOut.Text); // TimeOut設定



            //WaitTime = int.Parse(TxtTimeSendData.Text); // 次の関数実行までの待ち時間設定




            string s = sdData.Text;                 // 送信データ設定



            iDataLength = (short)sdData.TextLength; // 送信データ長設定




            // データ送信関数(応答なし)
            //ret = crwSendDataQR(
            //                     iPortNo,
            //                     lTimeOut,
            //                     iDSRCheck,
            //                     s,
            //                     iDataLength
            //                   );
            this.CallCrwFunction(
                    new CrwSendDataQRFunction(
                                 iPortNo,
                                 lTimeOut,
                                 iDSRCheck,
                                 s,
                                 iDataLength,
                                 crwSendDataQRResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwSendDataQRResultHandler(short ret);
        // 結果表示関数
        void crwSendDataQRResult(short ret)
        {
            int WaitTime = int.Parse(TxtTimeSendData.Text); // 次の関数実行までの待ち時間設定



            RetVal.Text = ret.ToString();   // 処理結果設定



            ErrMsg((uint)ret, "crwSendDataQR");

            if (OpSendData1.Checked == true)
            {
                // 指定 ミリ秒 待機する



                System.Threading.Thread.Sleep(WaitTime);
                ReceiveData_Click(null, null);  // データ受信関数実行



            } if (OpSendData2.Checked == true)
            {
                // 指定 ミリ秒 待機する



                System.Threading.Thread.Sleep(WaitTime);
                ReceiveBinaryData_Click(null, null);  // ﾊﾞｲﾅﾘﾃﾞｰﾀ受信関数実行



                SSTab1.SelectedTab = tabPage4;
            }
        }
        // 結果表示関数呼出し


        void crwSendDataQRResultInvoker(CrwFunction crwFunction)
        {
            CrwSendDataQRFunction f = (CrwSendDataQRFunction)crwFunction;
            this.BeginInvoke(new CrwSendDataQRResultHandler(crwSendDataQRResult), new object[] { f._ret });
        }
        #endregion

        #region (10) データ受信関数処理 crwReceiveData()
        /// <summary>
        /// (10) データ受信関数処理 crwReceiveData()
        /// </summary>
        private void ReceiveData_Click(object sender, EventArgs e)
        {
            //short ret = 0;

            short iPortNo;
            short iDSRCheck;
            short iDataLength = 0;
            IntPtr bpResDATA;

            RefreshMsg();   // 処理結果 TextBox クリア
            rdResData.Clear();
            rdResData.Refresh();
            rdDataLen.Clear();
            rdDataLen.Refresh();

            bpResDATA = ConvertStringToAnsiBSTR("");    // BSTR型初期化

            iPortNo = short.Parse(rdPortNo.Text);       // PortNo設定



            iDSRCheck = short.Parse(rdDSRCheck.Text);   // RecMode設定




            // データ受信関数
            //ret = crwReceiveData(
            //                      iPortNo,
            //                      iDSRCheck,
            //                      ref bpResDATA,
            //                      ref iDataLength
            //                     );
            this.CallCrwFunction(
                    new CrwReceiveDataFunction(
                                  iPortNo,
                                  iDSRCheck,
                                  ref bpResDATA,
                                  ref iDataLength,
                                  crwReceiveDataResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwReceiveDataResultHandler(
                short ret,
                ref IntPtr bpResDATA,
                ref short iDataLength);
        // 結果表示関数
        void crwReceiveDataResult(
                short ret,
                ref IntPtr bpResDATA,
                ref short iDataLength)
        {
            if (ret == 0)
            {
                rdResData.Text = ConvertAnsiBSTRToString(bpResDATA); // ﾚｽﾎﾟﾝｽﾃﾞｰﾀ設定



                rdDataLen.Text = iDataLength.ToString();             // ﾚｽﾎﾟﾝｽﾃﾞｰﾀ長設定



                toolTip1.SetToolTip(rdResData, rdResData.Text);      // ヒント



            }

            Marshal.FreeBSTR(bpResDATA);    // BSTR開放 

            RetVal.Text = ret.ToString();   // 処理結果設定



            ErrMsg((uint)ret, "crwReceiveData");
        }
        // 結果表示関数呼出し


        void crwReceiveDataResultInvoker(CrwFunction crwFunction)
        {
            CrwReceiveDataFunction f = (CrwReceiveDataFunction)crwFunction;
            this.BeginInvoke(
                    new CrwReceiveDataResultHandler(crwReceiveDataResult),
                    new object[] {
                            f._ret,
                            f._bpResDATA,
                            f._iDataLength
                    }
            );
        }
        #endregion

        #region (11) 電文データ送受信関数処理 crwSendDataRR()
        /// <summary>
        /// (11) 電文データ送受信関数処理 crwSendDataRR()
        /// </summary>
        private void SendDataRR_Click(object sender, EventArgs e)
        {
            //short ret = 0;

            short iPortNo;
            short iRetryCount;
            uint lTimeOut;
            short iDSRCheck;
            short iDataLength = 0;
            short piDataLength = 0;
            IntPtr bpResDATA;

            RefreshMsg();   // 処理結果 TextBox クリア
            sdrrResData.Clear();
            sdrrResDataLen.Clear();
            sdrrResData.Refresh();
            sdrrResDataLen.Refresh();

            bpResDATA = ConvertStringToAnsiBSTR("");    // BSTR型 初期化




            iPortNo = short.Parse(sdrrPortNo.Text);         // PortNo設定



            iRetryCount = short.Parse(sdrrRetryCount.Text); // iRetryCount設定



            iDSRCheck = short.Parse(sdrrDSRCheck.Text);     // RecMode設定



            lTimeOut = uint.Parse(sdrrTimeOut.Text);        // lTimeOut設定




            string lpData = sdrrSendData.Text;
            iDataLength = (short)sdrrSendData.TextLength;

            // 電文データ送受信関数処理



            //ret = crwSendDataRR(
            //                        iPortNo,
            //                        iRetryCount,
            //                        lTimeOut,
            //                        iDSRCheck,
            //                        lpData,
            //                        iDataLength,
            //                        ref bpResDATA,
            //                        ref piDataLength
            //                    );
            this.CallCrwFunction(
                    new CrwSendDataRRFunction(
                                    iPortNo,
                                    iRetryCount,
                                    lTimeOut,
                                    iDSRCheck,
                                    lpData,
                                    iDataLength,
                                    ref bpResDATA,
                                    ref piDataLength,
                                    crwSendDataRRResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwSendDataRRResultHandler(
                short ret,
                ref IntPtr bpResDATA,
                ref short piDataLength);
        // 結果表示関数
        void crwSendDataRRResult(
                short ret,
                ref IntPtr bpResDATA,
                ref short piDataLength)
        {
            if (ret == 0)
            {
                sdrrResData.Text = ConvertAnsiBSTRToString(bpResDATA);  // 受信ﾃﾞｰﾀ設定



                sdrrResDataLen.Text = piDataLength.ToString();  // 受信ﾃﾞｰﾀ長設定



            }

            toolTip1.SetToolTip(sdrrResData, sdrrResData.Text); // ヘルプ




            Marshal.FreeBSTR(bpResDATA); // BSTR型開放

            RetVal.Text = ret.ToString(); // 処理結果設定



            ErrMsg((uint)ret, "crwSendDataRR");
        }
        // 結果表示関数呼出し


        void crwSendDataRRResultInvoker(CrwFunction crwFunction)
        {
            CrwSendDataRRFunction f = (CrwSendDataRRFunction)crwFunction;
            this.BeginInvoke(
                    new CrwSendDataRRResultHandler(crwSendDataRRResult),
                    new object[] {
                            f._ret,
                            f._bpResDATA,
                            f._piDataLength
                    }
            );
        }
        #endregion

        #region (12) 電文ﾃﾞｰﾀ送信関数処理 crwSendDataBCC()
        /// <summary>
        /// (12) 電文ﾃﾞｰﾀ送信関数処理crwSendDataBCC()
        /// </summary>
        private void SendDataBCC_Click(object sender, EventArgs e)
        {
            //short ret = 0;

            short iPortNo;
            short iRetryCount;
            uint lTimeOut;
            short iDSRCheck;
            short iACKCheck;
            short iDataLength = 0;
            //int WaitTime;
            //int loop;
            IntPtr bpResDATA;

            RefreshMsg();   // 処理結果 TextBox クリア

            bpResDATA = ConvertStringToAnsiBSTR(""); // BSTR型初期化

            iPortNo = short.Parse(sdbccPortNo.Text);        // PortNo設定



            iACKCheck = short.Parse(sdbccACKCount.Text);    // ACKCheck設定



            iRetryCount = short.Parse(sdbccRetryCount.Text);// iRetryCount設定



            iDSRCheck = short.Parse(sdbccDSRCheck.Text);    // RecMode設定



            lTimeOut = uint.Parse(sdbccTimeOut.Text);       // lTimeOut設定



            //WaitTime = int.Parse(TxtTimeSendDataBCC.Text);  // WaitTime設定




            string lpData = sdbccSendData.Text;             // 送信ﾃﾞｰﾀ設定



            iDataLength = (short)sdbccSendData.TextLength;  // 送信ﾃﾞｰﾀ長設定




            // 電文ﾃﾞｰﾀ送信関数
            //ret = crwSendDataBCC(
            //                        iPortNo,
            //                        iACKCheck,
            //                        iRetryCount,
            //                        lTimeOut,
            //                        iDSRCheck,
            //                        lpData,
            //                        iDataLength
            //                    );
            this.CallCrwFunction(
                    new CrwSendDataBCCFunction(
                                    iPortNo,
                                    iACKCheck,
                                    iRetryCount,
                                    lTimeOut,
                                    iDSRCheck,
                                    lpData,
                                    iDataLength,
                                    crwSendDataBCCResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwSendDataBCCResultHandler(short ret, short iPortNo);
        // 結果表示関数
        void crwSendDataBCCResult(short ret, short iPortNo)
        {
            int WaitTime = int.Parse(TxtTimeSendDataBCC.Text);  // WaitTime設定
            
            RetVal.Text = ret.ToString();                       // 処理結果

            ErrMsg((uint)ret, "crwSendDataBCC");

            if (OpSendDataBCC1.Checked == true)                 // crwReceiveDataBCC             
            {

                System.Threading.Thread.Sleep(WaitTime);        // 指定 ミリ秒 待機する

                ReceiveDataBCC_Click(null, null);               // 電文ﾃﾞｰﾀ受信関数実行

            }
            else if (OpSendDataBCC2.Checked == true)            // crwReceiveBinaryData
            {

                System.Threading.Thread.Sleep(WaitTime);        // 指定 ミリ秒 待機する

                ReceiveBinaryData_Click(null, null);            // バイナリデータ受信関数実行

                SSTab1.SelectedTab = tabPage4;                  // Binary Funcのタブに切り替え
                
            }
            else if (OpSendDataBCC3.Checked == true)            // crwSetReceiveDataBCCEventPro
            {

                System.Threading.Thread.Sleep(WaitTime);        // 指定 ミリ秒 待機する

                SetReceiveDataBCCEventProc_Click(null, null);   // データ通信ハンドラ登録関数実行

                SSTab1.SelectedTab = tabPage5;                  // コールバック Funcのタブに切り替え

            }

            else if (OpSendDataBCC4.Checked == true)            // crwSetCommEventProc
            {
                if (OpEVT_RXCHAR_Return2.Checked == false) 
                {
                    
                    MessageBox.Show("事前にコールバック関数を指定して下さい。", "コールバック関数設定警告");
                    
                    SSTab1.SelectedTab = tabPage5;              // CallBackPageのタブに切り替え

                }
                else
                {

                    System.Threading.Thread.Sleep(WaitTime);    // 指定 ミリ秒 待機する

                    if (CommEventFlag[iPortNo - 1] == 0)
                    {
                        
                        cepEntry.Checked = true;

                        SetCommEventProc_Click(null, null);     // 通信イベントハンドラ登録関数実行

                        SSTab1.SelectedTab = tabPage5;          // コールバック Funcのタブに切り替え

                    }
                }
            }
        }

        // 結果表示関数呼出し
        void crwSendDataBCCResultInvoker(CrwFunction crwFunction)
        {
            CrwSendDataBCCFunction f = (CrwSendDataBCCFunction)crwFunction;
            this.BeginInvoke(new CrwSendDataBCCResultHandler(crwSendDataBCCResult), new object[] { f._ret, f._iPortNo });
        }
        #endregion

        #region (13) 電文ﾃﾞｰﾀ受信関数処理 crwReceiveDataBCC()
        /// <summary>
        /// (13) 電文ﾃﾞｰﾀ受信関数処理 crwReceiveDataBCC()
        /// </summary>
        private void ReceiveDataBCC_Click(object sender, EventArgs e)
        {
            //short ret = 0;

            short iPortNo;
            short iACKResponse;
            uint lTimeOut;
            short iDSRCheck;
            short piDataLength = 0;
            IntPtr bpResDATA;

            RefreshMsg();   // 処理結果 TextBox クリア
            rdbccResData.Clear();
            rdbccResDataLen.Clear();
            rdbccResData.Refresh();
            rdbccResDataLen.Refresh();

            bpResDATA = ConvertStringToAnsiBSTR(""); // BSTR型初期化

            iPortNo = short.Parse(rdbccPortNo.Text);            // PortNo設定



            iACKResponse = short.Parse(rdbccACKResponse.Text);  // ACKResponse設定



            lTimeOut = uint.Parse(rdbccTimeOut.Text);           // lTimeOut設定



            iDSRCheck = short.Parse(rdbccDSRCheck.Text);        // RecMode設定




            // 電文ﾃﾞｰﾀ受信関数
            //ret = crwReceiveDataBCC(
            //                        iPortNo,
            //                        iACKResponse,
            //                        lTimeOut,
            //                        iDSRCheck,
            //                        ref bpResDATA,
            //                        ref piDataLength
            //                    );
            this.CallCrwFunction(
                    new CrwReceiveDataBCCFunction(
                                    iPortNo,
                                    iACKResponse,
                                    lTimeOut,
                                    iDSRCheck,
                                    ref bpResDATA,
                                    ref piDataLength,
                                    crwReceiveDataBCCResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwReceiveDataBCCResultHandler(
                short ret,
                ref IntPtr bpResDATA,
                ref short piDataLength);
        // 結果表示関数
        void crwReceiveDataBCCResult(
                short ret,
                ref IntPtr bpResDATA,
                ref short piDataLength)
        {
            if (ret == 0)
            {
                rdbccResData.Text = ConvertAnsiBSTRToString(bpResDATA); // 受信ﾃﾞｰﾀ設定 BSTR → String
                rdbccResDataLen.Text = piDataLength.ToString();         // 受信ﾃﾞｰﾀ長設定



                toolTip1.SetToolTip(rdbccResData, rdbccResData.Text);   // ヒントメッセージ
            }

            Marshal.FreeBSTR(bpResDATA); // BSTR開放

            RetVal.Text = ret.ToString(); // 処理結果設定



            ErrMsg((uint)ret, "crwReceiveDataBCC");
        }
        // 結果表示関数呼出し


        void crwReceiveDataBCCResultInvoker(CrwFunction crwFunction)
        {
            CrwReceiveDataBCCFunction f = (CrwReceiveDataBCCFunction)crwFunction;
            this.BeginInvoke(
                    new CrwReceiveDataBCCResultHandler(crwReceiveDataBCCResult),
                    new object[] {
                            f._ret,
                            f._bpResDATA,
                            f._piDataLength
                    }
            );
        }
        #endregion

        #region (14) 受信バッファクリア関数処理 crwComRXBufferClear()
        /// <summary>
        /// (14) 受信バッファクリア関数処理 crwComRXBufferClear()
        /// </summary>
        private void ComRXBufferClear_Click(object sender, EventArgs e)
        {
            //short ret = 0;
            short iPortNo;

            RefreshMsg();   // 処理結果 TextBox クリア
            iPortNo = short.Parse(rdbccPortNo.Text); // PortNo設定




            // 受信バッファクリア
            //ret = crwComRXBufferClear(
            //                    iPortNo
            //);
            this.CallCrwFunction(
                    new CrwComRXBufferClearFunction(
                                iPortNo,
                                crwComRXBufferClearResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwComRXBufferClearResultHandler(short ret);
        // 結果表示関数
        void crwComRXBufferClearResult(short ret)
        {
            // 処理結果設定



            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "crwComRXBufferClear");
        }
        // 結果表示関数呼出し


        void crwComRXBufferClearResultInvoker(CrwFunction crwFunction)
        {
            CrwComRXBufferClearFunction f = (CrwComRXBufferClearFunction)crwFunction;
            this.BeginInvoke(new CrwComRXBufferClearResultHandler(crwComRXBufferClearResult), new object[] { f._ret });
        }
        #endregion

        #region (15) バイナリデータ送信関数ＱＲ処理 crwSendBinaryDataQR()
        /// <summary>
        /// (15) バイナリデータ送信関数ＱＲ処理 crwSendBinaryDataQR()
        /// </summary>
        unsafe private void SendBinaryDataQR_Click(object sender, EventArgs e)
        {
            //short ret = 0;
            short iPortNo;
            uint lTimeOut;
            short iCTSCheck;
            short iDSRCheck;
            short iDataLength;

            string str1;
            int j;
            //int WaitTime;

            byte* lpData = stackalloc byte[1024];   // 送信するデータ領域

            RefreshMsg();   // 処理結果 TextBox クリア

            iPortNo = short.Parse(sbdqPortNo.Text);             // PortNo設定



            lTimeOut = (uint)int.Parse(sbdqTimeOut.Text);       // TimeOut設定



            iCTSCheck = short.Parse(sbdqCTSCheck.Text);         // CTSCheck設定



            iDSRCheck = short.Parse(sbdqDSRCheck.Text);         // DSRCheck設定



            iDataLength = short.Parse(sbdqSendDataLen.Text);    // SendDataLength設定



            //WaitTime = int.Parse(TxtTimeSendBinaryDataQR.Text); // WaitTime設定




            if (sbdqSendData.TextLength != 0)
            {
                j = 0;
                for (int i = 1; i < sbdqSendData.TextLength; i += 2)
                {
                    str1 = Mid(sbdqSendData.Text, i, 2);
                    lpData[j] = (byte)Convert.ToInt32(str1, 16);    // "010203"→0x01 0x02 0x03へ変換
                    j = j + 1;
                }
            }
            // バイナリデータ送信関数ＱＲ
            //ret = crwSendBinaryDataQR(
            //                             iPortNo,
            //                             lTimeOut,
            //                             iDSRCheck,
            //                             iCTSCheck,
            //                             lpData,
            //                             iDataLength);
            this.CallCrwFunction(
                    new CrwSendBinaryDataQRFunction(
                                         iPortNo,
                                         lTimeOut,
                                         iDSRCheck,
                                         iCTSCheck,
                                         lpData,
                                         iDataLength,
                                         crwSendBinaryDataQRResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwSendBinaryDataQRResultHandler(short ret, short iPortNo);
        // 結果表示関数
        void crwSendBinaryDataQRResult(short ret, short iPortNo)
        {
            int WaitTime = int.Parse(TxtTimeSendBinaryDataQR.Text); // WaitTime設定

            RetVal.Text = ret.ToString();                           // 処理結果設定

            ErrMsg((uint)ret, "crwSendBinaryDataQR");

            if (OpSendBinaryDataQR1.Checked == true)                // バイナリデータ受信関数実行指定の場合

            {
                System.Threading.Thread.Sleep(WaitTime);            // 指定 ミリ秒 待機する

                ReceiveBinaryData_Click(null, null);                // バイナリデータ受信関数実行

            }
            else if (OpSendBinaryDataQR2.Checked == true)
            {
                // 指定 ミリ秒 待機する
                System.Threading.Thread.Sleep(WaitTime);

                OpEVT_RXCHAR_Return3.Checked = true;

                if (CommEventFlag[iPortNo - 1] == 0)
                {
                    cepEntry.Checked = true;
                    SetCommEventProc_Click(null, null);         // 通信イベントハンドラ登録関数実行



                }
                SSTab1.SelectedTab = tabPage5;  // TABﾍﾟｰｼﾞ切替
            }
        }
        // 結果表示関数呼出し


        void crwSendBinaryDataQRResultInvoker(CrwFunction crwFunction)
        {
            CrwSendBinaryDataQRFunction f = (CrwSendBinaryDataQRFunction)crwFunction;
            this.BeginInvoke(new CrwSendBinaryDataQRResultHandler(crwSendBinaryDataQRResult), new object[] { f._ret, f._iPortNo });
        }
        #endregion

        #region (16) バイナリデータ受信関数処理 crwReceiveBinaryData()
        /// <summary>
        /// (16) バイナリデータ受信関数処理 crwReceiveBinaryData()
        /// </summary>
        unsafe private void ReceiveBinaryData_Click(object sender, EventArgs e)
        {
            //short ret = 0;

            short iPortNo;
            uint lTimeOut;
            short iDSRCheck;
            short iDataLength;
            short piDataLength = 0;

            byte* lpData = stackalloc byte[1024];

            RefreshMsg();   // 処理結果 TextBox クリア
            rbdResData.Clear();
            rbdResData.Refresh();
            rbdDataLenRes.Clear();
            rbdDataLenRes.Refresh();

            iPortNo = short.Parse(rbdPortNo.Text);          // PortNo設定



            lTimeOut = (uint)int.Parse(rbdTimeOut.Text);    // TimeOut設定



            iDSRCheck = short.Parse(rbdDSRCheck.Text);      // DSRCheck設定



            iDataLength = short.Parse(rbdResDataLen.Text);  //SendDataLength設定




            // バイナリデータ受信関数
            //ret = crwReceiveBinaryData(
            //                             iPortNo,
            //                             lTimeOut,
            //                             iDSRCheck,
            //                             lpData,
            //                             iDataLength,
            //                             ref piDataLength);
            this.CallCrwFunction(
                    new CrwReceiveBinaryDataFunction(
                                         iPortNo,
                                         lTimeOut,
                                         iDSRCheck,
                                         lpData,
                                         iDataLength,
                                         ref piDataLength,
                                         crwReceiveBinaryDataResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwReceiveBinaryDataResultHandler(
                short ret,
                byte[] lpData,
                ref short piDataLength);
        // 結果表示関数
        void crwReceiveBinaryDataResult(
                short ret,
                byte[] lpData,
                ref short piDataLength)
        {
            string str = "";

            // 受信データ バイナリデータから文字列へ変換
            for (int i = 0; i < piDataLength; i++)
            {
                BinToStr(lpData[i], ref str);
                rbdResData.Text += str;
            }

            // ヒントメッセージ
            toolTip1.SetToolTip(rbdResData, rbdResData.Text);

            // 受信データ長設定



            rbdDataLenRes.Text = piDataLength.ToString();

            // 処理結果
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "crwReceiveBinaryData");
        }
        // 結果表示関数呼出し


        void crwReceiveBinaryDataResultInvoker(CrwFunction crwFunction)
        {
            CrwReceiveBinaryDataFunction f = (CrwReceiveBinaryDataFunction)crwFunction;
            this.BeginInvoke(
                    new CrwReceiveBinaryDataResultHandler(crwReceiveBinaryDataResult),
                    new object[] {
                            f._ret,
                            f._lpData,
                            f._piDataLength
                    }
            );
        }
        #endregion

        #region (17) レスポンス受信イベントハンドラ登録関数処理 crwSetResponseEventProc()
        /// <summary>
        /// (17) レスポンス受信イベントハンドラ登録関数処理 crwSetResponseEventProc()
        /// </summary>
        unsafe private void SetResponseEventProc_Click(object sender, EventArgs e)
        {
            //short ret = 0;

            short iPortNo;
            short iRecMode;
            uint lTimeOut;
            int lParam = 0;
            uint lEvent = 0;

            RefreshMsg();   // 処理結果 TextBox クリア

            iPortNo = short.Parse(repPortNo.Text);      // PortNo設定



            iRecMode = short.Parse(repRecMode.Text);    // RecMode設定



            lTimeOut = (uint)int.Parse(repTimeOut.Text);// TimeOut設定




            if (repCheckAll.Checked == true) // 全イベント対象の場合



            {
                lEvent = lEvent + EVT_RSP_CRW_RESPONSE + EVT_RSP_CRW_READY + EVT_RSP_CRW_BUSY
                                + EVT_RSP_CRW_ERR_RES_TIMEOUT + EVT_RSP_CRW_ERR_CTS_TIMEOUT
                                + EVT_RSP_CRW_ERR_DSR + EVT_RSP_CRW_ERR_BCC_RETRY + EVT_RSP_CRW_ERR_COMM_WRITE
                                + EVT_RSP_CRW_ERR_COMM_READ + EVT_RSP_CRW_CANCELED;
            }
            else
            {   // 個別イベント指定



                if (repCheck.Checked == true)
                {
                    lEvent = lEvent + EVT_RSP_CRW_RESPONSE;
                }
                if (repCheck2.Checked == true)
                {
                    lEvent = lEvent + EVT_RSP_CRW_READY;
                }
                if (repCheck3.Checked == true)
                {
                    lEvent = lEvent + EVT_RSP_CRW_BUSY;
                }
                if (repCheck4.Checked == true)
                {
                    lEvent = lEvent + EVT_RSP_CRW_ERR_RES_TIMEOUT;
                }
                if (repCheck5.Checked == true)
                {
                    lEvent = lEvent + EVT_RSP_CRW_ERR_CTS_TIMEOUT;
                }
                if (repCheck6.Checked == true)
                {
                    lEvent = lEvent + EVT_RSP_CRW_ERR_DSR;
                }
                if (repCheck7.Checked == true)
                {
                    lEvent = lEvent + EVT_RSP_CRW_ERR_BCC_RETRY;
                }
                if (repCheck8.Checked == true)
                {
                    lEvent = lEvent + EVT_RSP_CRW_ERR_COMM_WRITE;
                }
                if (repCheck9.Checked == true)
                {
                    lEvent = lEvent + EVT_RSP_CRW_ERR_COMM_READ;
                }
                if (repCheck10.Checked == true)
                {
                    lEvent = lEvent + EVT_RSP_CRW_CANCELED;
                }
            }

            myCallBack = new CallBack(crwResponseEventProc); // コールバック関数生成

            if (repEntry.Checked == true)
            {
                // レスポンス受信イベントハンドラ登録関数(関数登録)
                //ret = crwSetResponseEventProc(
                //                         iPortNo,
                //                         iRecMode,
                //                         lTimeOut,
                //                         myCallBack,
                //                         lParam,
                //                         lEvent);
                this.CallCrwFunction(
                        new CrwSetResponseEventProcFunction(
                                         iPortNo,
                                         iRecMode,
                                         lTimeOut,
                                         myCallBack,
                                         lParam,
                                         lEvent,
                                         crwSetResponseEventProcResultInvoker
                        )
                );
            }
            else
            {   // レスポンス受信イベントハンドラ登録関数(登録解除)
                //ret = crwSetResponseEventProc(
                //                         iPortNo,
                //                         iRecMode,
                //                         lTimeOut,
                //                         null,
                //                         lParam,
                //                         lEvent);
                this.CallCrwFunction(
                        new CrwSetResponseEventProcFunction(
                                         iPortNo,
                                         iRecMode,
                                         lTimeOut,
                                         null,
                                         lParam,
                                         lEvent,
                                         crwSetResponseEventProcResultInvoker
                        )
                );
            }
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwSetResponseEventProcResultHandler(short ret);
        // 結果表示関数
        void crwSetResponseEventProcResult(short ret)
        {
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "crwSetResponseEventProc");
        }
        // 結果表示関数呼出し


        void crwSetResponseEventProcResultInvoker(CrwFunction crwFunction)
        {
            CrwSetResponseEventProcFunction f = (CrwSetResponseEventProcFunction)crwFunction;
            this.BeginInvoke(new CrwSetResponseEventProcResultHandler(crwSetResponseEventProcResult), new object[] { f._ret });
        }
        #endregion

            #region レスポンス受信コールバック関数
            /// <summary>
            /// レスポンス受信コールバック関数
            /// </summary>
            /// <param name="iPortNo">イベントが発生したポートを返す</param>
            /// <param name="lEvent">コールバック関数で受け取るイベントの論理和</param>
            /// <param name="lpData">受信データを返却するエリアのポインタ</param>
            /// <param name="iDataLength">受信したデータの長さ</param>
            /// <param name="pParam">アプリケーションによって定義された値</param>
            /// <returns>なし</returns>
            public static int crwResponseEventProc(short iPortNo,
                                              int lEvent,
                                              [MarshalAs(UnmanagedType.BStr)] String lpData, 
                                              short iDataLength,
                                              int pParam
                                            )
            {
                string msg;
                string pno = iPortNo.ToString();
                string evt = lEvent.ToString();
                string dlen = iDataLength.ToString();

                msg = "iPortNo = " + pno + " lEvent = " + evt + " lpData = " + lpData + " iDataLength = " + dlen;
                MessageBox.Show(msg, "CallBack結果");
                return 0;
            }
            #endregion

        #region (18) 電文データ受信イベントハンドラ登録関数処理 crwSetReceiveDataBCCEventProc()
            /// <summary>
            /// (18) 電文データ受信イベントハンドラ登録関数処理 crwSetReceiveDataBCCEventProc()
            /// </summary>
            unsafe void SetReceiveDataBCCEventProc_Click(object sender, EventArgs e)
            {
                short iPortNo;
                short iACKResponse;
                uint lTimeOut;
                int lParam = 0;
                uint lEvent = 0;

                RefreshMsg();                                   // 処理結果 TextBox クリア

                iPortNo = short.Parse(bccPortNo.Text);          // PortNo設定

                iACKResponse = short.Parse(bccACKRes.Text);     // ACKResponce

                lTimeOut = (uint)int.Parse(bccTimeOut.Text);    // TimeOut設定

                if (bccChkAll.Checked == true)                  // 全イベント対象の場合
                {
                    lEvent = EVT_BCC_CRW_ALL;
                }
                else
                {   // 個別イベント指定

                    if (bccChk_0.Checked == true)
                    {
                        lEvent = lEvent + EVT_BCC_CRW_RESPONSE;
                    }
                    if (bccChk_1.Checked == true)
                    {
                        lEvent = lEvent + EVT_BCC_CRW_ERR_RES_TIMEOUT;
                    }
                    if (bccChk_2.Checked == true)
                    {
                        lEvent = lEvent + EVT_BCC_CRW_ERR_CTS_TIMEOUT;
                    }
                    if (bccChk_3.Checked == true)
                    {
                        lEvent = lEvent + EVT_BCC_CRW_ERR_DSR;
                    }
                    if (bccChk_4.Checked == true)
                    {
                        lEvent = lEvent + EVT_BCC_CRW_ERR_BCC_RETRY;
                    }
                    if (bccChk_5.Checked == true)
                    {
                        lEvent = lEvent + EVT_BCC_CRW_ERR_COMM_WRITE;
                    }
                    if (bccChk_6.Checked == true)
                    {
                        lEvent = lEvent + EVT_BCC_CRW_ERR_COMM_READ;
                    }
                    if (bccChk_7.Checked == true)
                    {
                        lEvent = lEvent + EVT_BCC_CRW_CANCELED;
                    }
                }

                myCallBack = new CallBack(crwReceiveDataBCCEventProc); // コールバック関数生成

                if (bccEntry.Checked == true)
                {
                    // レスポンス受信イベントハンドラ登録関数(関数登録)
                    //ret = crwSetResponseEventProc(
                    //                         iPortNo,
                    //                         iACKResponse,
                    //                         lTimeOut,
                    //                         myCallBack2,
                    //                         lParam,
                    //                         lEvent);
                    this.CallCrwFunction(
                            new CrwSetReceiveDataBCCEventProcFunction(
                                             iPortNo,
                                             iACKResponse,
                                             lTimeOut,
                                             myCallBack,
                                             lParam,
                                             lEvent,
                                             crwSetReceiveDataBCCEventProcResultInvoker
                            )
                    );
                }
                else
                {   // レスポンス受信イベントハンドラ登録関数(登録解除)
                    //ret = crwSetResponseEventProc(
                    //                         iPortNo,
                    //                         iACKResponse,
                    //                         lTimeOut,
                    //                         null,
                    //                         lParam,
                    //                         lEvent);
                    this.CallCrwFunction(
                            new CrwSetReceiveDataBCCEventProcFunction(
                                             iPortNo,
                                             iACKResponse,
                                             lTimeOut,
                                             null,
                                             lParam,
                                             lEvent,
                                             crwSetReceiveDataBCCEventProcResultInvoker
                            )
                    );
                }
            }
            // 結果表示関数のデリゲート宣言
            delegate void CrwSetReceiveDataBCCEventProcResultHandler(short ret);
            // 結果表示関数
            void crwSetReceiveDataBCCEventProcResult(short ret)
            {
                RetVal.Text = ret.ToString();
                ErrMsg((uint)ret, "crwSetReceiveDataBCCEvent");
            }
            // 結果表示関数呼出し
            void crwSetReceiveDataBCCEventProcResultInvoker(CrwFunction crwFunction)
            {
                CrwSetReceiveDataBCCEventProcFunction f = (CrwSetReceiveDataBCCEventProcFunction)crwFunction;
                this.BeginInvoke(new CrwSetReceiveDataBCCEventProcResultHandler(crwSetReceiveDataBCCEventProcResult), new object[] { f._ret });
            }
            #endregion

            #region 電文データ受信コールバック関数
            /// <summary>
            /// 電文データ受信コールバック関数
            /// </summary>
            /// <param name="iPortNo">イベントが発生したポートを返す</param>
            /// <param name="lEvent">コールバック関数で受け取るイベントの定数</param>
            /// <param name="bstrData">受信データを返却するエリアのポインタ</param>
            /// <param name="iDataLength">受信したデータの長さ</param>
            /// <param name="pParam">アプリケーションによって定義された値</param>
            /// <returns>なし</returns>
            public static int crwReceiveDataBCCEventProc(short iPortNo,
                                              int lEvent,
                                              [MarshalAs(UnmanagedType.BStr)] String bstrData,
                                              short iDataLength,
                                              int pParam
                                            )
            {
                string msg;
                string pno = iPortNo.ToString();
                string evt = lEvent.ToString();
                string dlen = iDataLength.ToString();

                msg = "iPortNo = " + pno + " lEvent = " + evt + " bstrData = " + bstrData + " iDataLength = " + dlen;
                MessageBox.Show(msg, "CallBack結果");
                return 0;
            }
            #endregion

        #region (19)通信イベントハンドラ登録関数 cwrSetCommEventProc()
        /// <summary>
        /// (19)通信イベントハンドラ登録関数 cwrSetCommEventProc()
        /// </summary>
        private void SetCommEventProc_Click(object sender, EventArgs e)
        {
            //short ret = 0;

            short iPortNo;
            int pParam = 0;
            uint lEvent = 0;

            RefreshMsg();   // 処理結果 TextBox クリア

            iPortNo = short.Parse(cepPortNo.Text); // PortNo設定




            if ((CommEventFlag[iPortNo - 1] == 1) &&
                (cepEntry.Checked == true))
            {
                MessageBox.Show("指定のポートは既に登録されています。", "コールバック関数設定警告");
                return;
            }

            if (cepCheckAll.Checked == true)
            {
                // 全イベントを設定



                lEvent = lEvent + EVT_CRW_RXCHAR + EVT_CRW_TXEMPTY + EVT_CRW_ERR_FRAME
                                + EVT_CRW_ERR_OVERRUN + EVT_CRW_ERR_PARITY + EVT_CRW_CTS
                                + EVT_CRW_DSR + EVT_CRW_RLSD + EVT_CRW_BREAK + EVT_CRW_RING;
            }
            else
            {
                // 個別イベントの指定



                if (cepCheck.Checked == true)
                {
                    lEvent = lEvent + EVT_CRW_RXCHAR;
                }
                if (cepCheck2.Checked == true)
                {
                    lEvent = lEvent + EVT_CRW_TXEMPTY;
                }
                if (cepCheck3.Checked == true)
                {
                    lEvent = lEvent + EVT_CRW_ERR_FRAME;
                }
                if (cepCheck4.Checked == true)
                {
                    lEvent = lEvent + EVT_CRW_ERR_OVERRUN;
                }
                if (cepCheck5.Checked == true)
                {
                    lEvent = lEvent + EVT_CRW_ERR_PARITY;
                }
                if (cepCheck6.Checked == true)
                {
                    lEvent = lEvent + EVT_CRW_CTS;
                }
                if (cepCheck7.Checked == true)
                {
                    lEvent = lEvent + EVT_CRW_DSR;
                }
                if (cepCheck8.Checked == true)
                {
                    lEvent = lEvent + EVT_CRW_RLSD;
                }
                if (cepCheck9.Checked == true)
                {
                    lEvent = lEvent + EVT_CRW_BREAK;
                }
                if (cepCheck10.Checked == true)
                {
                    lEvent = lEvent + EVT_CRW_RING;
                }
            }

            // 通信イベントハンドラ登録コールバック関数の生成
            myCallBack3 = new CallBack3(crwCallBackCommEventProc);

            // コールバック関数登録の場合



            if (cepEntry.Checked == true)
            {
                // 通信イベントハンドラ登録
                //ret = crwSetCommEventProc(
                //                         iPortNo,
                //                         myCallBack3,
                //                         pParam,
                //                         lEvent);
                this.CallCrwFunction(
                        new CrwSetCommEventProcFunction(
                                         iPortNo,
                                         myCallBack3,
                                         pParam,
                                         lEvent,
                                         crwSetCommEventProcResultInvoker
                        )
                );
                //if (ret == 0)
                //{
                //    CommEventFlag[iPortNo - 1] = 1;  // 通信イベントハンドラ登録中設定


                //
                //}
            }
            else
            {
                // 通信イベントハンドラ登録解除
                //ret = crwSetCommEventProc(
                //                         iPortNo,
                //                         null,
                //                         pParam,
                //                         lEvent);
                this.CallCrwFunction(
                        new CrwSetCommEventProcFunction(
                                         iPortNo,
                                         null,
                                         pParam,
                                         lEvent,
                                         crwSetCommEventProcResultInvoker
                        )
                );
                //if (ret == 0)
                //{
                //    CommEventFlag[iPortNo - 1] = 0;  // 通信イベントハンドラ登録中設定


                //
                //}
            }
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwSetCommEventProcResultHandler(short ret, short iPortNo, CallBack3 pCommEventProc);
        // 結果表示関数
        void crwSetCommEventProcResult(short ret, short iPortNo, CallBack3 pCommEventProc)
        {
            if (ret == 0)
            {
                if (null != pCommEventProc)
                {
                    CommEventFlag[iPortNo - 1] = 1;  // 通信イベントハンドラ登録中設定


                }
                else
                {
                    CommEventFlag[iPortNo - 1] = 0;  // 通信イベントハンドラ登録中設定


                }
            }

            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "crwSetCommEventProc");
        }
        // 結果表示関数呼出し


        void crwSetCommEventProcResultInvoker(CrwFunction crwFunction)
        {
            CrwSetCommEventProcFunction f = (CrwSetCommEventProcFunction)crwFunction;
            this.BeginInvoke(new CrwSetCommEventProcResultHandler(crwSetCommEventProcResult), new object[] { f._ret, f._iPortNo, f._pCommEventProc });
        }
        #endregion

            #region 通信イベントコールバック関数
            /// <summary>
            /// 通信イベントコールバック関数
            /// </summary>
            /// <param name="iPortNo">イベントが発生したポートを返す</param>
            /// <param name="lBufferLength">EVT_CRW_RXCHARイベントが発生したときの入力バッファのサイズ</param>
            /// <param name="lEvent">コールバック関数で受け取るイベントの論理和</param>
            /// <param name="pParam">アプリケーションによって定義された値</param>
            /// <returns>なし</returns>
            private int crwCallBackCommEventProc(
                                            short iPortNo,
                                              int lBufferLength,
                                              int lEvent,
                                              int pParam
                                            )
            {
                if (OpEVT_RXCHAR_Return.Checked == true)
                {
                    string msg;
                    string pno = iPortNo.ToString();        // iPortNo設定



                    string evt = lEvent.ToString();         // lEvent設定



                    string dlen = lBufferLength.ToString(); // 入力バッファサイズ指定




                    msg = "iPortNo = " + pno + " lEvent = " + evt + " iDataLength = " + dlen;

                    MessageBox.Show(msg, "CallBack結果");
                }
                else if (OpEVT_RXCHAR_Return1.Checked == true)  // crwReceiveData
                {
                    ReceiveData_Click(null, null);
                    SSTab1.SelectedTab = tabPage2;
                }
                else if (OpEVT_RXCHAR_Return2.Checked == true)  // crwReceiveDataBCC
                {
                    ReceiveDataBCC_Click(null, null);
                    SSTab1.SelectedTab = tabPage3;
                }
                else if (OpEVT_RXCHAR_Return3.Checked == true)  // crwReceiveBinaryData
                {
                    ReceiveBinaryData_Click(null, null);
                    SSTab1.SelectedTab = tabPage4;
                }


                return 0;
            }
            #endregion

        #region (20) PI Image Data 作成＆送信関数 crwPIDataSend()
        /// <summary>
        /// (20) PI Image Data 作成＆送信関数 crwPIDataSend()
        /// </summary>
        private void PIDataSend_Click(object sender, EventArgs e)
        {
            //short ret = 0;
            short iPortNo;
            short iRetryCount;
            short iDSRCheck;
            short iCTSCheck;
            short iWidth;
            short iHeith;
            short iStartX;
            short iStartY;
            uint lTimeOut;
            uint lComBufferSize;
            string strPathFileName;

            IntPtr bpCOMSTS;
            IntPtr bpERRSEN;

            RefreshMsg();   // 処理結果 TextBox クリア

            // 入力/参照項目(テキストボックス）の初期化
            pidsCOMSTS.Clear();
            pidsCOMSTS.Refresh();
            pidsERRSEN.Clear();
            pidsERRSEN.Refresh();

            // ポート番号等の情報取得
            iPortNo = short.Parse(pidsPortNo.Text);
            iRetryCount = short.Parse(pidsRetryCount.Text);
            iDSRCheck = short.Parse(pidsDSRCheck.Text);
            iCTSCheck = short.Parse(pidsCTSCheck.Text);
            iWidth = short.Parse(pidsWidth.Text);
            iHeith = short.Parse(pidsHeith.Text);
            iStartX = short.Parse(pidsStartX.Text);
            iStartY = short.Parse(pidsStartY.Text);
            lTimeOut = (uint)int.Parse(pidsTimeOut.Text);
            lComBufferSize = (uint)int.Parse(pidsComBufferSize.Text);
            strPathFileName = pidsstrPathFileName.Text;

            // BSTRの初期化
            bpCOMSTS = ConvertStringToAnsiBSTR("");     // BSTR型変数の初期化
            bpERRSEN = ConvertStringToAnsiBSTR("");     // 

            //コマンド送受信関数実行
            //ret = crwPIDataSend(
            //                iPortNo,
            //                iRetryCount,
            //                iDSRCheck,
            //                iCTSCheck,
            //                iWidth,
            //                iHeith,
            //                iStartX,
            //                iStartY,
            //                lTimeOut,
            //                lComBufferSize,
            //                strPathFileName
            //                ref bpCOMSTS,
            //                ref bpERRSEN,
            //);
            this.CallCrwFunction(
                    new CrwPIDataSendFunction(
                            iPortNo,
                            iRetryCount,
                            iDSRCheck,
                            iCTSCheck,
                            iWidth,
                            iHeith,
                            iStartX,
                            iStartY,
                            lTimeOut,
                            lComBufferSize,
                            strPathFileName,
                            ref bpCOMSTS,
                            ref bpERRSEN,
                            crwPIDataSendResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwPIDataSendResultHandler(
                short ret,
                ref IntPtr bpCOMSTS,
                ref IntPtr bpERRSEN);
        // 結果表示関数
        void crwPIDataSendResult(
                short ret,
                ref IntPtr bpCOMSTS,
                ref IntPtr bpERRSEN)
        {
            if (ret == 0)   // 結果が正常な場合
            {
                // 実行結果の表示
                pidsCOMSTS.Text = ConvertAnsiBSTRToString(bpCOMSTS);
                pidsERRSEN.Text = ConvertAnsiBSTRToString(bpERRSEN);
            }
            // 確保した BSTR を開放
            Marshal.FreeBSTR(bpCOMSTS);
            Marshal.FreeBSTR(bpERRSEN);

            // 処理結果の表示
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "crwPIDataSend");
        }
        // 結果表示関数呼出し


        void crwPIDataSendResultInvoker(CrwFunction crwFunction)
        {
            CrwPIDataSendFunction f = (CrwPIDataSendFunction)crwFunction;
            this.BeginInvoke(
                    new CrwPIDataSendResultHandler(crwPIDataSendResult),
                    new object[] {
                        f._ret,
                        f._bpCOMSTS,
                        f._bpERRSEN,
                }
            );
        }
        #endregion

        #region (21) IB Image Data 作成＆送信関数 crwIBBinarySend()
        /// <summary>
        /// (21) IB Image Data 作成＆送信関数 crwIBBinarySend()
        /// </summary>
        private void IBBinarySend_Click(object sender, EventArgs e)
        {
            //short ret = 0;
            short iPortNo;
            short iRetryCount;
            short iDSRCheck;
            short iCTSCheck;
            short iWidth;
            short iHeith;
            short iStartY;
            uint lTimeOut;
            uint lComBufferSize;
            string strPathFileName;

            IntPtr bpCOMSTS;
            IntPtr bpERRSEN;

            RefreshMsg();   // 処理結果 TextBox クリア

            // 入力/参照項目(テキストボックス）の初期化
            ibbsCOMSTS.Clear();
            ibbsCOMSTS.Refresh();
            ibbsERRSEN.Clear();
            ibbsERRSEN.Refresh();

            // ポート番号等の情報取得
            iPortNo = short.Parse(ibbsPortNo.Text);
            iRetryCount = short.Parse(ibbsRetryCount.Text);
            iDSRCheck = short.Parse(ibbsDSRCheck.Text);
            iCTSCheck = short.Parse(ibbsCTSCheck.Text);
            iWidth = short.Parse(ibbsWidth.Text);
            iHeith = short.Parse(ibbsHeith.Text);
            iStartY = short.Parse(ibbsStartY.Text);
            lTimeOut = (uint)int.Parse(ibbsTimeOut.Text);
            lComBufferSize = (uint)int.Parse(ibbsComBufferSize.Text);
            strPathFileName = ibbsstrPathFileName.Text;

            // BSTRの初期化
            bpCOMSTS = ConvertStringToAnsiBSTR("");     // BSTR型変数の初期化
            bpERRSEN = ConvertStringToAnsiBSTR("");     // 

            //コマンド送受信関数実行
            //ret = crwIBBinarySend(
            //                iPortNo,
            //                iRetryCount,
            //                iDSRCheck,
            //                iCTSCheck,
            //                iWidth,
            //                iHeith,
            //                iStartY,
            //                lTimeOut,
            //                lComBufferSize,
            //                strPathFileName
            //                ref bpCOMSTS,
            //                ref bpERRSEN,
            //);
            this.CallCrwFunction(
                    new CrwIBBinarySendFunction(
                            iPortNo,
                            iRetryCount,
                            iDSRCheck,
                            iCTSCheck,
                            iWidth,
                            iHeith,
                            iStartY,
                            lTimeOut,
                            lComBufferSize,
                            strPathFileName,
                            ref bpCOMSTS,
                            ref bpERRSEN,
                            crwIBBinarySendResultInvoker
                    )
            );
        }
        // 結果表示関数のデリゲート宣言
        delegate void CrwIBBinarySendResultHandler(
                short ret,
                ref IntPtr bpCOMSTS,
                ref IntPtr bpERRSEN);
        // 結果表示関数
        void crwIBBinarySendResult(
                short ret,
                ref IntPtr bpCOMSTS,
                ref IntPtr bpERRSEN)
        {

            if ((ret == RET_CRW_RESPONSE) || (ret == RET_CRW_READY))   // 結果が正常な場合
            {
                // 実行結果の表示
                ibbsCOMSTS.Text = ConvertAnsiBSTRToString(bpCOMSTS);  // ｽﾃｰﾀｽ情報設定
                ibbsERRSEN.Text = ConvertAnsiBSTRToString(bpERRSEN);  // ｾﾝｻｰ情報設定
            }

            // 確保した BSTR を開放
            Marshal.FreeBSTR(bpCOMSTS);
            Marshal.FreeBSTR(bpERRSEN);

            // 処理結果の表示
            RetVal.Text = ret.ToString();
            ErrMsg((uint)ret, "crwIBBinarySend");
        }
        // 結果表示関数呼出し


        void crwIBBinarySendResultInvoker(CrwFunction crwFunction)
        {
            CrwIBBinarySendFunction f = (CrwIBBinarySendFunction)crwFunction;
            this.BeginInvoke(
                    new CrwIBBinarySendResultHandler(crwIBBinarySendResult),
                    new object[] {
                        f._ret,
                        f._bpCOMSTS,
                        f._bpERRSEN,
                }
            );
        }
        #endregion

        #region 文字コード変換関数 crwCharCodeConv()
        /// <summary>
        /// 4.22.	文字コード変換関数 crwCharCodeConv()
        /// </summary>
        /// <param name="iConvMode">変換モード</param>
        /// <param name="csQConvStr">変換文字列</param>
        /// <returns>文字列型(System.IntPtr)<</returns>
        [DllImport("PCardRW64.dll")]
        static extern IntPtr crwCharCodeConv(
                                         short iConvMode,
                                         string csQConvStr);
        #endregion

        #region 文字列の指定された位置から、指定された文字数分の文字列を返します。Mid()
        /// <summary>
        /// 文字列の指定された位置から、指定された文字数分の文字列を返します。Mid()
        /// </summary>
        /// <param name="stTarget">取り出す元になる文字列。</param>
        /// <param name="iStart">取り出しを開始する位置。</param>
        /// <param name="iLength">取り出す文字数。</param>
        /// <returns>指定された位置から指定された文字数分の文字列。



        ///  文字数を超えた場合は、指定された位置からすべての文字列が返されます。</returns>
        private static string Mid(string stTarget, int iStart, int iLength)
        {
            if (iStart <= stTarget.Length)
            {
                if (iStart + iLength - 1 <= stTarget.Length)
                {
                    return stTarget.Substring(iStart - 1, iLength);
                }

                return stTarget.Substring(iStart - 1);
            }

            return string.Empty;
        }
        #endregion

        #region ×ボタン終了処理 Form1_FormClosed()
        /// <summary>
        /// ×ボタン終了処理 Form1_FormClosed()
        /// </summary>
        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            myWorker1.TerminateThread();
            myWorker2.TerminateThread();
            myWorker3.TerminateThread();
            
            Environment.Exit(0); // プログラム終了関数
        }
        #endregion

        #region string文字をバイナリデータへ変換
        /// <summary>
        /// string文字をバイナリデータへ変換
        /// </summary>
        unsafe public static void StrToBin(string strFrm, byte[] byFor)
        {
            byte by1st, by2nd, byCnv;

            for (int i = 0, byCnt = 0; i < strFrm.Length; i += 2)
            {
                by1st = System.Convert.ToByte(strFrm[i]);
                by2nd = System.Convert.ToByte(strFrm[i + 1]);

                byCnv = 0;
                //上位4ﾋﾞｯﾄ計算



                if ('0' <= by1st && by1st <= '9')
                {
                    byCnv = (byte)(((uint)by1st - 0x30) << 4);
                }
                else if ('A' <= by1st && by1st <= 'F')
                {
                    byCnv = (byte)(((uint)by1st - 0x41 + 10) << 4);
                }
                //下位4ﾋﾞｯﾄ計算



                if ('0' <= by2nd && by2nd <= '9')
                {
                    byCnv += (byte)((uint)by2nd - 0x30);
                }
                else if ('A' <= by2nd && by2nd <= 'F')
                {
                    byCnv += (byte)((uint)by2nd - 0x41 + 10);
                }

                byFor[byCnt] = byCnv;
                byCnt++;
            }
            return;
        }
        #endregion

        #region バイナリデータをstring文字へ変換(01 -> "01"  AA -> "AA") BinToStr()
        /// <summary>
        /// バイナリデータをstring文字へ変換(01 -> "01"  AA -> "AA") BinToStr()
        /// </summary>
        unsafe public static void BinToStr(byte byFrm, ref string strFor)
        {
            byte byMsb, byLsb;

            //初期化



            strFor = "";
            System.Text.Encoding shiftJisEncoding = System.Text.Encoding.GetEncoding("Shift_JIS");
            byte[] d = new byte[1];

            byMsb = (byte)((byFrm & 0xF0) >> 4);
            byLsb = (byte)(byFrm & 0x0F);

            //上位4ﾋﾞｯﾄ計算



            if (0x00 <= byMsb && byMsb <= 0x09)
            {
                d[0] = (byte)(byMsb + 0x30);
                strFor += shiftJisEncoding.GetString(d);
            }
            else if (0x0A <= byMsb && byMsb <= 0x0F)
            {
                d[0] = (byte)((byMsb - 0x0A) + 0x41);
                strFor += shiftJisEncoding.GetString(d);
            }
            //下位4ﾋﾞｯﾄ計算



            if (0x00 <= byLsb && byLsb <= 0x09)
            {
                d[0] = (byte)(byLsb + 0x30);
                strFor += shiftJisEncoding.GetString(d);
            }
            else if (0x0A <= byLsb && byLsb <= 0x0F)
            {
                d[0] = (byte)((byLsb - 0x0A) + 0x41);
                strFor += shiftJisEncoding.GetString(d);
            }
            return;
        }
        #endregion

        #region string から ANSI の BSTR への変換 ConvertStringToAnsiBSTR()
        /// <summary>
        /// string から ANSI の BSTR への変換 ConvertStringToAnsiBSTR()
        /// </summary>
        private static IntPtr ConvertStringToAnsiBSTR(string sz)
        {
            return SysAllocStringByteLen(sz, lstrlenA(sz));
        }
        #endregion

        #region ANSI の BSTR から string への変換 ConvertAnsiBSTRToString()
        /// <summary>
        /// ANSI の BSTR から string への変換 ConvertAnsiBSTRToString()
        /// </summary>
        private static string ConvertAnsiBSTRToString(IntPtr bstr)
        {
            return Marshal.PtrToStringAnsi(bstr, SysStringByteLen(bstr));
        }
        #endregion

        #region 処理結果メッセージの初期化
        /// <summary>
        /// 処理結果メッセージの初期化
        /// </summary>
        private void RefreshMsg()
        {
            RetVal.Clear();
            RetVal.BackColor = Color.White;
            RetVal.Refresh();

            RetMsg.Clear();
            RetMsg.BackColor = Color.White;
            RetMsg.Refresh();
        }
        #endregion

        #region エラーメッセージ表示処理 ErrMsg()
        /// <summary>
        /// エラーメッセージ表示処理 ErrMsg()
        /// </summary>
        /// <param name="err">エラーコード渡します</param>
        /// <param name="ms">エラーメッセージを渡します</param>
        private void ErrMsg(uint err, string ms)
        {
            label126.Text = ms;
            switch (err)
            {
                case RET_CRW_SUCCESS: //RET_CRW_ACK,RET_CRW_RESPONSE
                    RetVal.BackColor = Color.Green;
                    RetMsg.BackColor = Color.Green;
                    RetMsg.Text = "OK/ACK/RESPONSE";
                    break;

                case RET_CRW_FAILURE:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "FAILURE/NAK/READY";
                    break;

                case RET_CRW_BUSY:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "BUSY";
                    break;

                case RET_CRW_ERR_PARAM:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "PARAM ERR";
                    break;

                case RET_CRW_ERR_PORT:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "PORT ERR";
                    break;

                case RET_CRW_ERR_RES_TIMEOUT:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "RES TIMEOUT";
                    break;

                case RET_CRW_ERR_CTS_TIMEOUT:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "CTS TIMEOUT";
                    break;

                case RET_CRW_ERR_DSR_TIMEOUT:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "DSR ERR";
                    break;

                case RET_CRW_ERR_BCC_RETRY:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "BCC ERR";
                    break;

                case RET_CRW_ERR_COMM_WRITE:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "COMM WRITE ERR";
                    break;

                case RET_CRW_ERR_COMM_READ:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "COMM READ ERR";
                    break;

                case RET_CRW_ERR_BUSY:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "非同期処理実行中！";
                    break;

                default:
                    RetVal.BackColor = Color.Red;
                    RetMsg.BackColor = Color.Red;
                    RetMsg.Text = "OTHER ERR";
                    break;
            }
        }
        #endregion

        #region 通信イベントハンドラ全イベントチェック cepCheckAll_CheckedChanged()
        /// <summary>
        /// 通信イベントハンドラ全イベントチェック cepCheckAll_CheckedChanged()
        /// </summary>
        private void cepCheckAll_CheckedChanged(object sender, EventArgs e)
        {
            if (cepCheckAll.Checked == true)
            {   // コントロール無効
                cepCheck.Enabled = false;
                cepCheck2.Enabled = false;
                cepCheck3.Enabled = false;
                cepCheck4.Enabled = false;
                cepCheck5.Enabled = false;
                cepCheck6.Enabled = false;
                cepCheck7.Enabled = false;
                cepCheck8.Enabled = false;
                cepCheck9.Enabled = false;
                cepCheck10.Enabled = false;
            }
            else
            {   // コントロール有効
                cepCheck.Enabled = true;
                cepCheck2.Enabled = true;
                cepCheck3.Enabled = true;
                cepCheck4.Enabled = true;
                cepCheck5.Enabled = true;
                cepCheck6.Enabled = true;
                cepCheck7.Enabled = true;
                cepCheck8.Enabled = true;
                cepCheck9.Enabled = true;
                cepCheck10.Enabled = true;
            }
        }
        #endregion

        private void scrCmdParam_TextChanged(object sender, EventArgs e)
        {
            int lng = scrCmdParam.TextLength;
            scrParamLen.Text = lng.ToString();
        }

        private void repCheckAll_CheckedChanged_1(object sender, EventArgs e)
        {
            if (repCheckAll.Checked == true)
            {
                repCheck.Enabled = false;
                repCheck2.Enabled = false;
                repCheck3.Enabled = false;
                repCheck4.Enabled = false;
                repCheck5.Enabled = false;
                repCheck6.Enabled = false;
                repCheck7.Enabled = false;
                repCheck8.Enabled = false;
                repCheck9.Enabled = false;
                repCheck10.Enabled = false;

            }
            else
            {
                repCheck.Enabled = true;
                repCheck2.Enabled = true;
                repCheck3.Enabled = true;
                repCheck4.Enabled = true;
                repCheck5.Enabled = true;
                repCheck6.Enabled = true;
                repCheck7.Enabled = true;
                repCheck8.Enabled = true;
                repCheck9.Enabled = true;
                repCheck10.Enabled = true;
            }
        }

        private void sdrrSendData_TextChanged_1(object sender, EventArgs e)
        {
            int lng = sdrrSendData.TextLength;
            sdrrSendDataLen.Text = lng.ToString();
        }

        private void scCmdParam_TextChanged(object sender, EventArgs e)
        {
            int lng = scCmdParam.TextLength;
            scParamLen.Text = lng.ToString();
        }

        private void sbdqSendData_TextChanged(object sender, EventArgs e)
        {
            int lng = sbdqSendData.TextLength / 2;
            sbdqSendDataLen.Text = lng.ToString();
        }

        private void sdbccSendData_TextChanged_1(object sender, EventArgs e)
        {
            int lng = sdbccSendData.TextLength;
            sdbccSendDataLen.Text = lng.ToString();

        }

        private void OpSendData1_CheckedChanged(object sender, EventArgs e)
        {
            if (OpSendData1.Checked == true)
            {
                rdResData.Clear();
                rdResData.Refresh();
                rdDataLen.Clear();
                rdDataLen.Refresh();
            }
        }

        private void OpSendData2_CheckedChanged(object sender, EventArgs e)
        {
            if (OpSendData2.Checked == true)
            {
                rbdResData.Clear();
                rbdResData.Refresh();
            }
        }

        private void OpSendBinaryDataQR1_CheckedChanged(object sender, EventArgs e)
        {
            if (OpSendBinaryDataQR1.Checked == true)
            {
                rbdResData.Clear();
                rbdResData.Refresh();
                rbdDataLenRes.Clear();
                rbdDataLenRes.Refresh();
            }
        }

        private void OpSendBinaryDataQR2_CheckedChanged(object sender, EventArgs e)
        {
            if (OpSendBinaryDataQR2.Checked == true)
            {
                rbdResData.Clear();
                rbdResData.Refresh();
                rbdDataLenRes.Clear();
                rbdDataLenRes.Refresh();
                OpEVT_RXCHAR_Return3.Checked = true;
            }
        }

        private void radioButton20_CheckedChanged(object sender, EventArgs e)
        {
            if (OpSendDataBCC1.Checked == true)
            {
                rdbccResData.Clear();
                rdbccResDataLen.Clear();
                rdbccResData.Refresh();
                rdbccResDataLen.Refresh();
            }
        }

        private void OpEVT_RXCHAR_Return4_CheckedChanged(object sender, EventArgs e)
        {
            if (OpEVT_RXCHAR_Return2.Checked == true)
            {
                rdbccResData.Clear();
                rdbccResDataLen.Clear();
                rdbccResData.Refresh();
                rdbccResDataLen.Refresh();
            }
        }

        private void OpSendCommand1_CheckedChanged(object sender, EventArgs e)
        {
            if (OpSendCommand1.Checked == true)
            {
                rrCOMSTS.Clear();
                rrCOMSTS.Refresh();
                rrERRSEN.Clear();
                rrERRSEN.Refresh();
                rrResDATA.Clear();
                rrResDATA.Refresh();
            }
        }

        /// <summary>
        /// CRW関数呼出し


        /// </summary>
        /// <param name="crwFunction"></param>
        private void CallCrwFunction(CrwFunction crwFunction)
        {

            Worker worker = GetSelectedThread();
            if (null == worker) 
            {
                RunningThread.Text = "Main";
                crwFunction.Call();
            }
            else         
            {
                RunningThread.Text = worker.GetName();
                worker.CallCrwFunction(crwFunction);
            }
        }

        /// <summary>
        /// CRW関数実行スレッド取得


        /// </summary>
        /// <returns></returns>
        private Worker GetSelectedThread()
        {
            if (opThreadMain.Checked)       // 「メイン」ラジオボタンがチェックされている？


            {
                return null;
            }
            if (opThreadWorker1.Checked)    // 「ワーカスレッド１」ラジオボタンがチェックされている？


            {
                return myWorker1;
            }
            if (opThreadWorker2.Checked)    // 「ワーカスレッド２」ラジオボタンがチェックされている？


            {
                return myWorker2;
            }
            if (opThreadWorker3.Checked)    // 「ワーカスレッド３」ラジオボタンがチェックされている？


            {
                return myWorker3;
            }
            return null;
        }

        /// <summary>
        /// ファイルバージョン情報取得
        /// </summary>
        /// <param name="FullPath"></param>
        /// <param name="FileVersion"></param>
        /// <returns></returns>
        private bool GetVerion(string FullPath, ref string FileVersion)
        {
            bool ret = false;
            try
            {
                System.Diagnostics.FileVersionInfo info =
                        System.Diagnostics.FileVersionInfo.GetVersionInfo(FullPath);
                FileVersion = info.FileVersion;
                ret = true;
            }
            catch (System.IO.FileNotFoundException)
            {
            }
            return ret;
        }

        /// <summary>
        /// formをアンロード時の処理
        /// </summary>
        /// <param name="sender"></param>/
        /// <param name="e"></param>
        private void Form1_FormClosing(object sender, EventArgs e)
        {
            short iPortNo = 0;

            // Fromアンロード時に、ポートをクローズする
            if (portcount > 0)
            {
                for (iPortNo = 1; iPortNo < 256; iPortNo++)
                {
                    if (portflag[iPortNo-1] == true)
                        crwClosePort(iPortNo);
                }
            }
        }


        /// <summary>
        /// 指定したトークンの出現箇所を取得
        /// </summary>
        /// <param name="token"></param>
        /// <param name="data"></param>
        /// <param name="index"></param>
        /// <param name="offsetflag"></param>
        private void lookuptoken(string token, string data, ref int index, bool offsetflag)
        {
            index = data.IndexOf(token);
            // 文字列の長さを追加
            if (offsetflag == true)
            {
                // リテラルのままではLengthが使えないので変数にコピー
                string _token = token;
                index += _token.Length - 1;
            }
        }

        /// <summary>
        /// 次のトークンの出現箇所を取得
        /// </summary>
        /// <param name="data"></param>
        /// <param name="index"></param>
        private void nexttoken(string data, ref int index)
        {
            // 空白か'='を飛ばす


            while (true)
            {
                char c = data[++index];
                if (c != '=' && c != ' ') break;
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            toolTip1 = new ToolTip(this.components);
        }

        private void CmbLog_SelectedIndexChanged(object sender, EventArgs e)
        {
            string strLog = "";
            string Work = "";

            // クラスの実体を生成する。
            classIniFile Ini = new classIniFile();

            // PCardRW64.INI情報を取得する。
            strLog  = Ini.ReadIni("Log", "Logging", "");

            // PCardRW64.INIへ書き込む
            Work = Mid(CmbLog.Text, 1, 2);
            Work = Work.Trim();
            Ini.WriteIni("Log", "Logging", Work);

            if (strLog != Work)
            {
                DialogResult ret = MessageBox.Show(@"LOG設定の設定が変更になっており、反映させるには一度アプリケーションを再起動させる必要があります。"
                                    + System.Environment.NewLine +
                                    "終了させる場合は「はい」を、しない場合は「いいえ」をクリックして下さい",
                                    "PCRW64_VB",
                                    MessageBoxButtons.YesNo ,
                                    MessageBoxIcon.Exclamation,
                                    MessageBoxDefaultButton.Button3);
                if (ret == DialogResult.Yes )
                {
                    // アプリケーションを終了する
                    Application.Exit();
                }
            }
            //ToolTipを作成する
            toolTip1.SetToolTip(CmbLog, CmbLog.Text);
        }


    }
}

