﻿Imports System
Imports System.Collections.Generic
Imports System.Text
Imports System.Runtime.InteropServices

Namespace VB_sample

#Region "CRW関数呼出し全クラスの基底クラス"

    Public MustInherit Class CrwFunction

#Region "メンバフィールド定義"
        ' 関数宣言
        Delegate Sub CrwFunctionResultHandler(ByVal crwFunction As CrwFunction)
        ' CRW関数の実行結果を表示する関数
        Protected CrwFunctionResult As CrwFunctionResultHandler

#End Region

        ' VBのコンストラクタは クラス名でなくNewで指定

        Protected Sub New(ByVal crwFunctionResultHandler As CrwFunctionResultHandler)
            'RaiseEvent CrwFunctionResult = New CrwFunctionResultHandler(crwFunctionResultHandler)
            '        CrwFunctionResult += New CrwFunctionResultHandler(AddressOf crwFunctionResultHandler)
            CrwFunctionResult = crwFunctionResultHandler
        End Sub


        ' CRW関数呼出し

        Public Sub CallFunk()

            DoCall()
            CrwFunctionResult(Me)

        End Sub

        ' 各CRW関数の呼出し処理

        Public MustOverride Sub DoCall()
    End Class
#End Region

#Region "(1) シリアルポート名取得関数呼出しクラス"
    ''' <summary>
    ''' (1) シリアルポート名取得関数呼出しクラス
    ''' </summary>
    Public Class CrwGetPortNamesFunction
        Inherits CrwFunction

        ''' <summary>
        ''' (1) シリアルポート名取得関数呼出しクラス
        ''' </summary>
        ''' <param name="bpPortNames">使用可能なシリアルポート名をCSV形式で返却するポインタ</param>
        ''' <param name="piNumOfPort">使用可能なシリアルポートの数を返却するポインタ</param>
        ''' <returns>ブール型, 論理型(Boolean)</returns>
        ''' <remarks></remarks>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwGetPortNames( _
            ByRef bpPortNames As IntPtr, _
            ByRef piNumOfPort As Short) As Boolean
        End Function


#Region "メンバフィールド定義"
        Public _ret As Boolean
        Public _bpPortNames As System.IntPtr
        Public _piNumOfPort As Short
#End Region


        'Public CrwGetPortNamesFunction( _
        'ByRef bpPortNames as System.IntPtr, _
        'ByRef piNumOfPort As Short)
        ' Newがコンストラクタ
        Public Sub New( _
            ByRef bpPortNames As System.IntPtr, _
            ByRef piNumOfPort As Short, _
            ByRef crwFunctionResultHandler As CrwFunctionResultHandler)

            MyBase.New(crwFunctionResultHandler)
            _ret = False
            _bpPortNames = bpPortNames
            _piNumOfPort = piNumOfPort

        End Sub

        ' CRW関数呼び出し

        Public Overrides Sub DoCall()
            _ret = crwGetPortNames(_bpPortNames, _
                                   _piNumOfPort)

        End Sub


    End Class

#End Region

#Region "(2) COMポート情報取得関数呼出しクラス"
    ''' <summary>
    ''' (2) COMポート情報取得関数呼出しクラス
    ''' </summary>
    Public Class CrwGetComDevInfoFunction
        Inherits CrwFunction

#Region "ＣＯＭポート情報取得関数 crwGetComDevInfo()"
        ''' <summary>
        ''' ＣＯＭポート情報取得関数 crwGetComDevInfo()
        ''' </summary>
        ''' <param name="iPortNo">取得したいシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="bpDriveDesc">シリアルポートのディスクリプター名を返却するエリアのポインタ</param>
        ''' <param name="bpProviderName">シリアルポートドライバーのプロバイダーを返却するエリアのポインタ</param>
        ''' <param name="bpDriverDate">シリアルポートドライバーの日付を返却するエリアのポインタ</param>
        ''' <param name="bpDriverVersion">シリアルポートドライバーのバージョンを返却するエリアのポインタ</param>
        ''' <returns>ブール型, 論理型(Boolean)</returns>        
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwGetComDevInfo( _
            ByVal iPortNo As Short, _
            ByRef bpDriveDesc As IntPtr, _
            ByRef bpProviderName As IntPtr, _
            ByRef bpDriverDate As IntPtr, _
            ByRef bpDriverVersion As IntPtr) As Boolean
        End Function

#End Region

#Region "メンバフィールド定義"
        Public _ret As Boolean
        Public _iPortNo As Short
        Public _bpDriveDesc As System.IntPtr
        Public _bpProviderName As System.IntPtr
        Public _bpDriverDate As System.IntPtr
        Public _bpDriverVersion As System.IntPtr
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="bpDriveDesc"></param>
        ''' <param name="bpProviderName"></param>
        ''' <param name="bpDriverDate"></param>
        ''' <param name="bpDriverVersion"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        Public Sub New(ByVal iPortNo As Short, _
             ByRef bpDriveDesc As System.IntPtr, _
             ByRef bpProviderName As System.IntPtr, _
             ByRef bpDriverDate As System.IntPtr, _
             ByRef bpDriverVersion As System.IntPtr, _
             ByRef crwFunctionResultHandler As CrwFunctionResultHandler)

            MyBase.New(crwFunctionResultHandler)

            _ret = False
            _iPortNo = iPortNo
            _bpDriveDesc = bpDriveDesc
            _bpProviderName = bpProviderName
            _bpDriverDate = bpDriverDate
            _bpDriverVersion = bpDriverVersion
        End Sub


        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwGetComDevInfo( _
                 _iPortNo, _
                 _bpDriveDesc, _
                 _bpProviderName, _
                 _bpDriverDate, _
                 _bpDriverVersion)
        End Sub
    End Class
#End Region

#Region "(3) ポートオープン関数呼出しクラス"
    ''' <summary>
    ''' (3) ポートオープン関数呼出しクラス
    ''' </summary>
    Public Class CrwOpenPortFunction
        Inherits CrwFunction

#Region "ポートオープン関数 crwOpenPort()"


        'unsafe static extern short crwOpenPort(
        ''' <summary>
        ''' ポートオープン関数 crwOpenPort()
        ''' </summary>
        ''' <param name="iPortNo">オープンするシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="lBaudRate">シリアルポートの通信速度（2400、4800、9600、19200、38400、57600、115200）</param>
        ''' <param name="lpDataBit">シリアルポートのデータビット長（7または8）</param>
        ''' <param name="lpParity">シリアルポートのパリティチェック（ N：なし ／ E：偶数 ／ O：奇数）</param>
        ''' <returns>整数型(short)</returns>   
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwOpenPort( _
                                         ByVal iPortNo As Short, _
                                         ByVal lBaudRate As Int32, _
                                         ByRef lpDataBit As Char, _
                                         ByRef lpParity As Char) As Short
        End Function

#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _lBaudRate As Int32
        Public _lpDataBit As Char
        Public _lpParity As Char
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="lBaudRate"></param>
        ''' <param name="lpDataBit"></param>
        ''' <param name="lpParity"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        Public Sub New( _
                                         ByVal iPortNo As Short, _
                                         ByVal lBaudRate As Int32, _
                                         ByRef lpDataBit As Char, _
                                         ByRef lpParity As Char, _
                                         ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)
            _ret = 0
            _iPortNo = iPortNo
            _lBaudRate = lBaudRate
            _lpDataBit = lpDataBit
            _lpParity = lpParity
        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()

            Dim lpDataBit As Char = _lpDataBit
            Dim lpParity As Char = _lpParity
            _ret = crwOpenPort( _
                     _iPortNo, _
                     _lBaudRate, _
                     _lpDataBit, _
                     _lpParity)
        End Sub

    End Class
#End Region

#Region "(4) ポートクローズ関数呼出しクラス"
    ''' <summary>
    ''' (4) ポートクローズ関数呼出しクラス
    ''' </summary>
    Public Class CrwClosePortFunction
        Inherits CrwFunction

#Region "ポートクローズ関数 crwClosePort()"


        'unsafe static extern short crwClosePort(
        ''' <summary>
        ''' ポートクローズ関数 crwClosePort()
        ''' </summary>
        ''' <param name="iPortNo">オープンするシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <returns>整数型(short)</returns>   
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwClosePort(ByVal iPortNo As Short) As Short
        End Function

#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        Public Sub New( _
                                         ByVal iPortNo As Short, _
                                         ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)
            _ret = 0
            _iPortNo = iPortNo
        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()

            _ret = crwClosePort(_iPortNo)
        End Sub

    End Class
#End Region

#Region "(5) コマンド送受信関数呼出しクラス"
    ''' <summary>
    ''' (5) コマンド送受信関数呼出しクラス
    ''' </summary>
    Public Class CrwSendCommandRRFunction
        Inherits CrwFunction

#Region "コマンド送受信関数 crwSendCommandRR()"


        'unsafe static extern short crwOpenPort(
        ''' <summary>
        ''' コマンド送受信関数 crwSendCommandRR() 
        ''' </summary>
        ''' <param name="iPortNo">送信するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="iRecMode">ビジーステータス受信の時にポーリング再送を行なうかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="lTimeOut">ACK/NAK待ち及びCTSオン待ちタイマー値（単位：msec）</param>
        ''' <param name="lBusyTimeOut">ビジーステータスの終了待ちタイマー値（単位：msec）</param>
        ''' <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ　（0:しない／0以外:する）</param>
        ''' <param name="lpCommandCode">機器のコマンドコード（2バイト）</param>
        ''' <param name="lpCommandParameter">機器のコマンドのパラメータ(パラメータ無しの時はNull)</param>
        ''' <param name="iParameterLength">コマンドパラメータの長さ</param>
        ''' <param name="bpCOMSTS">レスポンスのコマンドコード(=COM$)・レディステータスのステータス情報(=STS$)を返却するエリアのポインタ（2バイト）</param>
        ''' <param name="bpERRSEN">レスポンスのエラーコード(=ERR$)・レディステータスのセンサー情報(=SEN$)を返却するエリアのポインタ（2バイト）</param>
        ''' <param name="bpResDATA">レスポンスのデータ部分(=DATA$)を返却するエリアのポインタ(センサー情報以外の追加情報がある場合は、以降の情報は“bpResDATA”に格納される)</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwSendCommandRR( _
                                         ByVal iPortNo As Short, _
                                         ByVal iRecMode As Short, _
                                         ByVal lTimeOut As Int32, _
                                         ByVal lBusyTimeOut As Int32, _
                                         ByVal iDSRCheck As Short, _
                                         ByVal lpCommandCode As String, _
                                         ByVal lpCommandParameter As String, _
                                         ByVal iParameterLength As Short, _
                                         ByRef bpCOMSTS As System.IntPtr, _
                                         ByRef bpERRSEN As System.IntPtr, _
                                         ByRef bpResDATA As System.IntPtr) As Short
        End Function


#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _iRecMode As Short
        Public _lTimeOut As Int32
        Public _lBusyTimeOut As Int32
        Public _iDSRCheck As Short
        Public _lpCommandCode As String
        Public _lpCommandParameter As String
        Public _iParameterLength As Short
        Public _bpCOMSTS As System.IntPtr
        Public _bpERRSEN As System.IntPtr
        Public _bpResDATA As System.IntPtr
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="iRecMode"></param>
        ''' <param name="lTimeOut"></param>
        ''' <param name="lBusyTimeOut"></param>
        ''' <param name="iDSRCheck"></param>
        ''' <param name="lpCommandCode"></param>
        ''' <param name="lpCommandParameter"></param>
        ''' <param name="iParameterLength"></param>
        ''' <param name="bpCOMSTS"></param>
        ''' <param name="bpERRSEN"></param>
        ''' <param name="bpResDATA"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                        ByVal iPortNo As Short, _
                        ByVal iRecMode As Short, _
                        ByVal lTimeOut As Int32, _
                        ByVal lBusyTimeOut As Int32, _
                        ByVal iDSRCheck As Short, _
                        ByVal lpCommandCode As String, _
                        ByVal lpCommandParameter As String, _
                        ByVal iParameterLength As Short, _
                        ByRef bpCOMSTS As System.IntPtr, _
                        ByRef bpERRSEN As System.IntPtr, _
                        ByRef bpResDATA As System.IntPtr, _
                        ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _iRecMode = iRecMode
            _lTimeOut = lTimeOut
            _lBusyTimeOut = lBusyTimeOut
            _iDSRCheck = iDSRCheck
            _lpCommandCode = lpCommandCode
            _lpCommandParameter = lpCommandParameter
            _iParameterLength = iParameterLength
            _bpCOMSTS = bpCOMSTS
            _bpERRSEN = bpERRSEN
            _bpResDATA = bpResDATA
        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwSendCommandRR( _
                                         _iPortNo, _
                                         _iRecMode, _
                                         _lTimeOut, _
                                         _lBusyTimeOut, _
                                         _iDSRCheck, _
                                         _lpCommandCode, _
                                         _lpCommandParameter, _
                                         _iParameterLength, _
                                         _bpCOMSTS, _
                                         _bpERRSEN, _
                                         _bpResDATA)
        End Sub
    End Class
#End Region

#Region "(6) コマンド送信関数呼出しクラス"
    ''' <summary>
    ''' (6) コマンド送信関数呼出しクラス
    ''' </summary>
    Public Class CrwSendCommandFunction
        Inherits CrwFunction

#Region "コマンド送信関数 crwSendCommand()"
        ''' <summary>
        ''' コマンド送信関数 crwSendCommand()
        ''' </summary>
        ''' <param name="iPortNo">コマンドを送信するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="lTimeOut">ACK/NAK待ち及びCTSオン待ちタイマー値（単位：msec）</param>
        ''' <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="lpCommandCode">機器のコマンドコード（2バイト）</param>
        ''' <param name="lpCommandParameter">機器のコマンドのパラメータ（パラメータ無しの時はNULL）</param>
        ''' <param name="iParameterLength">コマンドパラメータの長さ</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwSendCommand( _
                                         ByVal iPortNo As Short, _
                                         ByVal lTimeOut As Int32, _
                                         ByVal iDSRCheck As Short, _
                                         ByVal lpCommandCode As String, _
                                         ByVal lpCommandParameter As String, _
                                         ByVal iParameterLength As Short) As Short
        End Function

#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _lTimeOut As Int32
        Public _iDSRCheck As Short
        Public _lpCommandCode As String
        Public _lpCommandParameter As String
        Public _iParameterLength As Short
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="lTimeOut"></param>
        ''' <param name="iDSRCheck"></param>
        ''' <param name="lpCommandCode"></param>
        ''' <param name="lpCommandParameter"></param>
        ''' <param name="iParameterLength"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                        ByVal iPortNo As Short, _
                        ByVal lTimeOut As Int32, _
                        ByVal iDSRCheck As Short, _
                        ByVal lpCommandCode As String, _
                        ByVal lpCommandParameter As String, _
                        ByVal iParameterLength As Short, _
                        ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _lTimeOut = lTimeOut
            _iDSRCheck = iDSRCheck
            _lpCommandCode = lpCommandCode
            _lpCommandParameter = lpCommandParameter
            _iParameterLength = iParameterLength
        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwSendCommand( _
                                         _iPortNo, _
                                         _lTimeOut, _
                                         _iDSRCheck, _
                                         _lpCommandCode, _
                                         _lpCommandParameter, _
                                         _iParameterLength)
        End Sub
    End Class
#End Region

#Region "(7) レスポンス受信関数呼出しクラス"
    ''' <summary>
    ''' (7) レスポンス受信関数呼出しクラス
    ''' </summary>
    Public Class CrwReceiveResponseFunction
        Inherits CrwFunction

#Region "コマンド送受信関数 crwSendCommandRR()"
        ''' <summary>
        ''' レスポンス受信関数  crwReceiveResponse()
        ''' </summary>
        ''' <param name="iPortNo">レスポンスを受信するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="iRecMode">ビジーステータス受信時にポーリング再送を行うかどうかのフラグ</param>
        ''' <param name="lTimeOut">ポーリングに対する機器からの応答待ちタイマー値（単位：msec）</param>
        ''' <param name="iDSRCheck">DSR信号線のチェックを行うかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="bpCOMSTS">ステータス情報、またはコマンドコードを返却するエリアのポインタ（2バイト）</param>
        ''' <param name="bpERRSEN">センサー情報、またはエラーコードを返却するエリアのポインタ（2バイト）</param>
        ''' <param name="bpResDATA">レスポンスのデータ部分(=DATA$)を返却するエリアのポインタ(センサー情報以外の追加情報がある場合は、以降の情報は“bpResDATA”に格納される)</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwReceiveResponse( _
                                         ByVal iPortNo As Short, _
                                         ByVal iRecMode As Short, _
                                         ByVal lTimeOut As Int32, _
                                         ByVal iDSRCheck As Short, _
                                         ByRef bpCOMSTS As System.IntPtr, _
                                         ByRef bpERRSEN As System.IntPtr, _
                                         ByRef bpResDATA As System.IntPtr) As Short

        End Function


#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _iRecMode As Short
        Public _lTimeOut As Int32
        Public _iDSRCheck As Short
        Public _bpCOMSTS As System.IntPtr
        Public _bpERRSEN As System.IntPtr
        Public _bpResDATA As System.IntPtr
#End Region


        ' コンストラクタ

        Public Sub New( _
                        ByVal iPortNo As Short, _
                        ByVal iRecMode As Short, _
                        ByVal lTimeOut As Int32, _
                        ByVal iDSRCheck As Short, _
                        ByRef bpCOMSTS As System.IntPtr, _
                        ByRef bpERRSEN As System.IntPtr, _
                        ByRef bpResDATA As System.IntPtr, _
                        ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _iRecMode = iRecMode
            _lTimeOut = lTimeOut
            _iDSRCheck = iDSRCheck
            _bpCOMSTS = bpCOMSTS
            _bpERRSEN = bpERRSEN
            _bpResDATA = bpResDATA
        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwReceiveResponse( _
                                         _iPortNo, _
                                         _iRecMode, _
                                         _lTimeOut, _
                                         _iDSRCheck, _
                                         _bpCOMSTS, _
                                         _bpERRSEN, _
                                         _bpResDATA)
        End Sub
    End Class
#End Region

#Region "(8) データ送信関数(応答あり)呼出しクラス"
    ''' <summary>
    ''' (8) データ送信関数(応答あり)呼出しクラス
    ''' </summary>
    Public Class CrwSendDataWRFunction
        Inherits CrwFunction

#Region "データ送信関数（応答あり）crwSendDataWR()"

        ''' <summary>
        ''' データ送信関数（応答あり）crwSendDataWR()
        ''' </summary>
        ''' <param name="iPortNo">データを送信するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="lTimeOut">ACK/NAK待ち及びCTSオン待ちタイマー値（単位：msec）</param>
        ''' <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="lpData">送信するデータ</param>
        ''' <param name="iDataLength">送信するデータの長さ</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwSendDataWR( _
                             ByVal iPortNo As Short, _
                             ByVal lTimeOut As Int32, _
                             ByVal iDSRCheck As Short, _
                             ByVal lpData As IntPtr, _
                             ByVal iDataLength As Short) As Short

        End Function


#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _lTimeOut As Int32
        Public _iDSRCheck As Short
        Public _lpData As IntPtr
        Public _iDataLength As Short
#End Region
        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="lTimeOut"></param>
        ''' <param name="iDSRCheck"></param>
        ''' <param name="lpData"></param>
        ''' <param name="iDataLength"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                            ByVal iPortNo As Short, _
                            ByVal lTimeOut As Int32, _
                            ByVal iDSRCheck As Short, _
                            ByVal lpData As IntPtr, _
                            ByVal iDataLength As Short, _
                            ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _lTimeOut = lTimeOut
            _iDSRCheck = iDSRCheck
            _lpData = lpData
            _iDataLength = iDataLength

        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwSendDataWR( _
                                     _iPortNo, _
                                     _lTimeOut, _
                                     _iDSRCheck, _
                                     _lpData, _
                                     _iDataLength)
        End Sub
    End Class
#End Region

#Region "(9) データ送信関数(応答なし)呼出しクラス"
    ''' <summary>
    ''' (9) データ送信関数(応答なし)呼出しクラス
    ''' </summary>
    Public Class CrwSendDataQRFunction
        Inherits CrwFunction

#Region "データ送信関数（応答なし） crwSendDataQR()"
        ''' <summary>
        ''' データ送信関数（応答なし） crwSendDataQR()
        ''' </summary>
        ''' <param name="iPortNo">データを送信するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="lTimeOut">ACK/NAK待ち及びCTSオン待ちタイマー値（単位：msec）</param>
        ''' <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="lpData">送信するデータ</param>
        ''' <param name="iDataLength">送信するデータの長さ</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwSendDataQR( _
                    ByVal iPortNo As Short, _
                    ByVal lTimeOut As Int32, _
                    ByVal iDSRCheck As Short, _
                    ByVal lpData As System.IntPtr, _
                    ByVal iDataLength As Short) As Short
        End Function


#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _lTimeOut As Int32
        Public _iDSRCheck As Short
        Public _lpData As System.IntPtr
        Public _iDataLength As Short
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="lTimeOut"></param>
        ''' <param name="iDSRCheck"></param>
        ''' <param name="lpData"></param>
        ''' <param name="iDataLength"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                             ByVal iPortNo As Short, _
                             ByVal lTimeOut As Int32, _
                             ByVal iDSRCheck As Short, _
                             ByVal lpData As String, _
                             ByVal iDataLength As System.IntPtr, _
                             ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _lTimeOut = lTimeOut
            _iDSRCheck = iDSRCheck
            _lpData = lpData
            _iDataLength = iDataLength

        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwSendDataQR( _
                                     _iPortNo, _
                                     _lTimeOut, _
                                     _iDSRCheck, _
                                     _lpData, _
                                     _iDataLength)
        End Sub
    End Class
#End Region

#Region "(10) データ受信関数呼出しクラス"
    ''' <summary>
    ''' (10) データ受信関数呼出しクラス
    ''' </summary>
    Public Class CrwReceiveDataFunction
        Inherits CrwFunction

#Region "データ受信関数 crwReceiveData()"
        ''' <summary>
        ''' データ受信関数 crwReceiveData()
        ''' </summary>
        ''' <param name="iPortNo">受信するシリアルポートの番号</param>
        ''' <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外:する / 0:しない）</param>
        ''' <param name="bpResDATA">レスポンスのデータ部分を返却するエリアのポインタ</param>
        ''' <param name="iDataLength">受信したデータの長さ</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwReceiveData( _
                    ByVal iPortNo As Short, _
                    ByVal iDSRCheck As Short, _
                    ByRef bpResDATA As System.IntPtr, _
                    ByRef iDataLength As Short) As Short
        End Function


#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _iDSRCheck As Short
        Public _bpResDATA As System.IntPtr
        Public _iDataLength As Short
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="iDSRCheck"></param>
        ''' <param name="bpResDATA"></param>
        ''' <param name="iDataLength"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                             ByVal iPortNo As Short, _
                             ByVal iDSRCheck As Short, _
                             ByRef bpResDATA As System.IntPtr, _
                             ByRef iDataLength As Short, _
                             ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _iDSRCheck = iDSRCheck
            _bpResDATA = bpResDATA
            _iDataLength = iDataLength

        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwReceiveData( _
                                     _iPortNo, _
                                     _iDSRCheck, _
                                     _bpResDATA, _
                                     _iDataLength)
        End Sub
    End Class
#End Region

#Region "(11) 電文データ送受信関数呼出しクラス"
    ''' <summary>
    ''' (11) 電文データ送受信関数呼出しクラス
    ''' </summary>
    Public Class CrwSendDataRRFunction
        Inherits CrwFunction

#Region "電文データ送受信関数 crwSendDataRR()"
        ''' <summary>
        ''' 電文データ送受信関数 crwSendDataRR()
        ''' </summary>
        ''' <param name="iPortNo">送受信するシリアルポート番号</param>
        ''' <param name="iRetryCount">データ送信・応答データ受信タイムアウト時のリトライ回数</param>
        ''' <param name="lTimeOut">リトライ時の待ち時間（単位:msec）</param>
        ''' <param name="iDSRCheck">信号線をチェックするかどうかのフラグ（0以外:する / 0:しない）</param>
        ''' <param name="lpData">送信するデータ</param>
        ''' <param name="iDataLength">送信するデータの長さ</param>
        ''' <param name="bpResDATA">レスポンスのデータ部分を返却するエリアポインタ</param>
        ''' <param name="piDataLength">受信したデータの長さ</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwSendDataRR( _
                                         ByVal iPortNo As Short, _
                                         ByVal iRetryCount As Short, _
                                         ByVal lTimeOut As Int32, _
                                         ByVal iDSRCheck As Short, _
                                         ByVal lpData As System.IntPtr, _
                                         ByVal iDataLength As Short, _
                                         ByRef bpResDATA As System.IntPtr, _
                                         ByRef piDataLength As Short) As Short
        End Function


#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _iRetryCount As Short
        Public _lTimeOut As Int32
        Public _iDSRCheck As Short
        Public _lpData As System.IntPtr
        Public _iDataLength As Short
        Public _bpResDATA As System.IntPtr
        Public _piDataLength As Short
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="iRetryCount"></param>
        ''' <param name="lTimeOut"></param>
        ''' <param name="iDSRCheck"></param>
        ''' <param name="lpData"></param>
        ''' <param name="iDataLength"></param>
        ''' <param name="bpResDATA"></param>
        ''' <param name="piDataLength"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                        ByVal iPortNo As Short, _
                        ByVal iRetryCount As Short, _
                        ByVal lTimeOut As Int32, _
                        ByVal iDSRCheck As Short, _
                        ByVal lpData As System.IntPtr, _
                        ByVal iDataLength As Short, _
                        ByVal bpResDATA As System.IntPtr, _
                        ByVal piDataLength As Short, _
                        ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _iRetryCount = iRetryCount
            _lTimeOut = lTimeOut
            _iDSRCheck = iDSRCheck
            _lpData = lpData
            _iDataLength = iDataLength
            _bpResDATA = bpResDATA
            _piDataLength = piDataLength
        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwSendDataRR( _
                        _iPortNo, _
                        _iRetryCount, _
                        _lTimeOut, _
                        _iDSRCheck, _
                        _lpData, _
                        _iDataLength, _
                        _bpResDATA, _
                        _piDataLength)
        End Sub
    End Class
#End Region

#Region "(12) 電文ﾃﾞｰﾀ送信関数呼出しクラス"
    ''' <summary>
    ''' (12) 電文ﾃﾞｰﾀ送信関数呼出しクラス
    ''' </summary>
    Public Class CrwSendDataBCCFunction
        Inherits CrwFunction

#Region "電文データ送信関数 crwSendDataBCC()"
        ''' <summary>
        ''' 電文データ送信関数 crwSendDataBCC()
        ''' </summary>
        ''' <param name="iPortNo">データを送信するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="iACKCheck">ACK/NAKを待つかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="iRetryCount">データ送信・ACK/NAK受信タイムアウト時のリトライ回数</param>
        ''' <param name="lTimeOut">ACK/NAK待ち及びCTS ON待ちタイマー（単位:msec）(IACKCheck=0のときはACK/NAK待ちタイマーのみ無効)</param>
        ''' <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="lpData">送信するデータ</param>
        ''' <param name="iDataLength">送信するデータの長さ</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwSendDataBCC( _
                                         ByVal iPortNo As Short, _
                                         ByVal iACKCheck As Short, _
                                         ByVal iRetryCount As Short, _
                                         ByVal lTimeOut As Int32, _
                                         ByVal iDSRCheck As Short, _
                                         ByVal lpData As System.IntPtr, _
                                         ByVal iDataLength As Short) As Short
        End Function


#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _iACKCheck As Short
        Public _iRetryCount As Short
        Public _lTimeOut As Int32
        Public _iDSRCheck As Short
        Public _lpData As System.IntPtr
        Public _iDataLength As Short
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="iACKCheck"></param>
        ''' <param name="iRetryCount"></param>
        ''' <param name="lTimeOut"></param>
        ''' <param name="iDSRCheck"></param>
        ''' <param name="lpData"></param>
        ''' <param name="iDataLength"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                        ByVal iPortNo As Short, _
                        ByVal iACKCheck As Short, _
                        ByVal iRetryCount As Short, _
                        ByVal lTimeOut As Int32, _
                        ByVal iDSRCheck As Short, _
                        ByVal lpData As System.IntPtr, _
                        ByVal iDataLength As Short, _
                        ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)
            _ret = 0
            _iPortNo = iPortNo
            _iACKCheck = iACKCheck
            _iRetryCount = iRetryCount
            _lTimeOut = lTimeOut
            _iDSRCheck = iDSRCheck
            _lpData = lpData
            _iDataLength = iDataLength

        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwSendDataBCC( _
                        _iPortNo, _
                        _iACKCheck, _
                        _iRetryCount, _
                        _lTimeOut, _
                        _iDSRCheck, _
                        _lpData, _
                        _iDataLength)
        End Sub
    End Class
#End Region

#Region "(13) 電文ﾃﾞｰﾀ受信関数呼出しクラス"
    ''' <summary>
    ''' (13) 電文ﾃﾞｰﾀ受信関数呼出しクラス
    ''' </summary>
    Public Class CrwReceiveDataBCCFunction
        Inherits CrwFunction

#Region "電文データ受信関数 crwReceiveDataBCC()"
        ''' <summary>
        ''' 電文データ受信関数 crwReceiveDataBCC()
        ''' </summary>
        ''' <param name="iPortNo">レスポンスを受信するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="iACKResponse">ACK/NAKを返却するかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="lTimeOut">CTS ON待ちタイマー（単位:msec）   / iACKResponse =0のときは無効</param>
        ''' <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外:する / 0:しない）</param>
        ''' <param name="bpResDATA">レスポンスのデータ部分を返却するエリアのポインタ</param>
        ''' <param name="piDataLength">受信したデータの長さ</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwReceiveDataBCC( _
                                         ByVal iPortNo As Short, _
                                         ByVal iACKResponse As Short, _
                                         ByVal lTimeOut As Int32, _
                                         ByVal iDSRCheck As Short, _
                                         ByRef bpResDATA As System.IntPtr, _
                                         ByRef piDataLength As Short) As Short
        End Function


#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _iACKResponse As Short
        Public _lTimeOut As Int32
        Public _iDSRCheck As Short
        Public _bpResDATA As System.IntPtr
        Public _piDataLength As Short
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="iACKResponse"></param>
        ''' <param name="lTimeOut"></param>
        ''' <param name="iDSRCheck"></param>
        ''' <param name="bpResDATA"></param>
        ''' <param name="piDataLength"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                    ByVal iPortNo As Short, _
                    ByVal iACKResponse As Short, _
                    ByVal lTimeOut As Int32, _
                    ByVal iDSRCheck As Short, _
                    ByVal bpResDATA As System.IntPtr, _
                    ByVal piDataLength As Short, _
                    ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _iACKResponse = iACKResponse
            _lTimeOut = lTimeOut
            _iDSRCheck = iDSRCheck
            _bpResDATA = bpResDATA
            _piDataLength = piDataLength

        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwReceiveDataBCC( _
                        _iPortNo, _
                        _iACKResponse, _
                        _lTimeOut, _
                        _iDSRCheck, _
                        _bpResDATA, _
                        _piDataLength)
        End Sub
    End Class
#End Region

#Region "(15) 受信バッファクリア関数呼出しクラス"
    ''' <summary>
    ''' (15) 受信バッファクリア関数呼出しクラス
    ''' </summary>
    Public Class CrwComRXBufferClearFunction
        Inherits CrwFunction

#Region "受信バッファークリア関数 crwComRXBufferClear()"
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwComRXBufferClear(ByVal iPortNo As Short) As Short
        End Function
#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                    ByVal iPortNo As Short, _
                    ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo

        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwComRXBufferClear(_iPortNo)
        End Sub

    End Class
#End Region

#Region "(19) バイナリデータ送信関数ＱＲ呼出しクラス"
    ''' <summary>
    ''' (19) バイナリデータ送信関数ＱＲ呼出しクラス
    ''' </summary>
    Public Class CrwSendBinaryDataQRFunction
        Inherits CrwFunction

#Region " バイナリデータ送信関数 crwSendBinaryDataQR()"
        ''' <summary>
        ''' バイナリデータ送信関数 crwSendBinaryDataQR() 
        ''' </summary>
        ''' <param name="iPortNo">シリアルポートの番号</param>
        ''' <param name="lTimeOut">CTSオン待ちタイマー値（単位：msec）</param>
        ''' <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0：しない／0以外：する）</param>
        ''' <param name="iCTSCheck">CTS信号線をチェックするかどうかのフラグ（0：しない／0以外：する）</param>
        ''' <param name="lpData">送信するデータ</param>
        ''' <param name="iDataLength">送信するデータの長さ</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwSendBinaryDataQR( _
                                         ByVal iPortNo As Short, _
                                         ByVal lTimeOut As Int32, _
                                         ByVal iDSRCheck As Short, _
                                         ByVal iCTSCheck As Short, _
                                         ByVal lpData As Byte(), _
                                         ByVal iDataLength As Short) As Short

        End Function
#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _lTimeOut As Int32

        Public _iDSRCheck As Short
        Public _iCTSCheck As Short
        Public _lpData As Byte()
        Public _iDataLength As Short
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="lTimeOut"></param>
        ''' <param name="iDSRCheck"></param>
        ''' <param name="iCTSCheck"></param>
        ''' <param name="lpData"></param>
        ''' <param name="iDataLength"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                         ByVal iPortNo As Short, _
                         ByVal lTimeOut As Int32, _
                         ByVal iDSRCheck As Short, _
                         ByVal iCTSCheck As Short, _
                         ByVal lpData As Byte(), _
                         ByVal iDataLength As Short, _
                    ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _lTimeOut = lTimeOut
            _iDSRCheck = iDSRCheck
            _iCTSCheck = iCTSCheck
            _lpData = lpData
            _iDataLength = iDataLength

        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwSendBinaryDataQR( _
                    _iPortNo, _
                    _lTimeOut, _
                    _iDSRCheck, _
                    _iCTSCheck, _
                    _lpData, _
                    _iDataLength)
        End Sub
    End Class
#End Region

#Region "(20) バイナリデータ受信関数呼出しクラス"
    ''' <summary>
    ''' (20) バイナリデータ受信関数呼出しクラス
    ''' </summary>
    Public Class CrwReceiveBinaryDataFunction
        Inherits CrwFunction

#Region "バイナリデータ受信関数 crwReceiveBinaryData()"
        ''' <summary>
        ''' バイナリデータ受信関数 crwReceiveBinaryData() 
        ''' </summary>
        ''' <param name="iPortNo">受信するシリアルポートの番号</param>
        ''' <param name="lTimeOut">データの受信待ちタイマー値（単位：msec）</param>
        ''' <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0：しない／0以外：する）</param>
        ''' <param name="lpData">受信データを返却するエリアのポインタ</param>
        ''' <param name="iDataLength">受信データを返却するエリアのサイズ</param>
        ''' <param name="piDataLength">受信したデータの長さ</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwReceiveBinaryData( _
                                         ByVal iPortNo As Short, _
                                         ByVal lTimeOut As Int32, _
                                         ByVal iDSRCheck As Short, _
                                         ByVal lpData As IntPtr, _
                                         ByVal iDataLength As Short, _
                                         ByRef piDataLength As Short) As Short

        End Function
#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _lTimeOut As Int32
        Public _iDSRCheck As Short
        Public _lpData() As Byte
        Public _iDataLength As Short
        Public _piDataLength As Short

#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="lTimeOut"></param>
        ''' <param name="iDSRCheck"></param>
        ''' <param name="lpData"></param>
        ''' <param name="iDataLength"></param>
        ''' <param name="piDataLength"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                         ByVal iPortNo As Short, _
                         ByVal lTimeOut As Int32, _
                         ByVal iDSRCheck As Short, _
                         ByRef lpData() As Byte, _
                         ByVal iDataLength As Short, _
                         ByVal piDataLength As Short, _
                    ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _lTimeOut = lTimeOut
            _iDSRCheck = iDSRCheck
            _lpData = lpData
            _iDataLength = iDataLength
            _piDataLength = piDataLength

        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            Dim size As Integer = Marshal.SizeOf(_lpData(0)) * _lpData.Length
            Dim pnt As IntPtr = Marshal.AllocHGlobal(size)
            Marshal.Copy(_lpData, 0, pnt, _lpData.Length)
            _ret = crwReceiveBinaryData( _
                    _iPortNo, _
                    _lTimeOut, _
                    _iDSRCheck, _
                    pnt, _
                    _iDataLength, _
                    _piDataLength)
            Marshal.Copy(pnt, _lpData, 0, _lpData.Length)
            Marshal.FreeHGlobal(pnt)
        End Sub
    End Class
#End Region

#Region "(21) 通信中DSR/CTS信号監視設定関数呼出しクラス"
    ''' <summary>
    ''' (21) 通信中DSR/CTS信号監視設定関数呼出しクラス
    ''' </summary>
    Public Class CrwComDSRCTSswFunction
        Inherits CrwFunction

#Region " 通信中DSR/CTS信号監視設定関数 crwComDSRCTSsw()"
        ''' <summary>
        ''' 通信中DSR/CTS信号監視設定関数 crwComDSRCTSsw()
        ''' </summary>
        ''' <param name="iPortNo">DSR・CTSフローを監視するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="iDSRCheck">通信中のDSR信号線をチェックするかどうかのフラグ（0:しない／0以外:する）初期値：0以外:する</param>
        ''' <param name="iCTSCheck">通信中のCTS信号線をチェックするかどうかのフラグ（0:しない／0以外:する）初期値：0以外:する</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwComDSRCTSsw( _
                                         ByVal iPortNo As Short, _
                                         ByVal iDSRCheck As Short, _
                                         ByVal iCTSCheck As Short) As Short

        End Function
#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _iDSRCheck As Short
        Public _iCTSCheck As Short
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="iDSRCheck"></param>
        ''' <param name="iCTSCheck"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                         ByVal iPortNo As Short, _
                         ByVal iDSRCheck As Short, _
                         ByVal iCTSCheck As Short, _
                    ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _iDSRCheck = iDSRCheck
            _iCTSCheck = iCTSCheck

        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwComDSRCTSsw( _
                    _iPortNo, _
                    _iDSRCheck, _
                    _iCTSCheck)
        End Sub
    End Class
#End Region

#Region "(22) レスポンス受信イベントハンドラ登録関数呼出しクラス"
    ''' <summary>
    ''' (22) レスポンス受信イベントハンドラ登録関数呼出しクラス
    ''' </summary>
    Public Class CrwSetResponseEventProcFunction
        Inherits CrwFunction

#Region " レスポンス受信イベントハンドラ登録関数 crwSetResponseEventProc()"
        ''' <summary>
        ''' レスポンス受信イベントハンドラ登録関数 crwSetResponseEventProc() 
        ''' </summary>
        ''' <param name="iPortNo">受信するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="iRecMode">ビジーステータス受信時にポーリング再送を行うかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="lTimeOut">データの受信待ちタイマー値(単位:msec) （0 msec指定で無限待ち）</param>
        ''' <param name="pResponseEventProc">crwResponseEventProc関数のポインタ(NULLを指定:登録解除)</param>
        ''' <param name="lParam">アプリケーションによって定義された値</param>
        ''' <param name="lEvent">コールバック関数で受け取るイベントの論理和</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwSetResponseEventProc( _
                                         ByVal iPortNo As Short, _
                                         ByVal iRecMode As Short, _
                                         ByVal lTimeOut As Int32, _
                                         ByVal pResponseEventProc As CallBack, _
                                         ByVal lParam As Integer, _
                                         ByVal lEvent As Short) As Short
        End Function

#End Region

#Region "メンバフィールド定義"
            Public _ret As Short
            Public _iRecMode As Short
            Public _iPortNo As Short
            Public _lTimeOut As Int32
            Public _pResponseEventProc As CallBack
            Public _lParam As Integer
            Public _lEvent As Short
#End Region

            ''' <summary>
            ''' コンストラクタ
            ''' </summary>
            ''' <param name="iPortNo"></param>
            ''' <param name="iRecMode"></param>
            ''' <param name="lTimeOut"></param>
            ''' <param name="pResponseEventProc"></param>
            ''' <param name="lParam"></param>
            ''' <param name="lEvent"></param>
            ''' <param name="crwFunctionResultHandler"></param>
            ''' <remarks></remarks>
            Public Sub New( _
                            ByVal iPortNo As Short, _
                            ByVal iRecMode As Short, _
                            ByVal lTimeOut As Int32, _
                            ByVal pResponseEventProc As CallBack, _
                            ByVal lParam As Integer, _
                            ByVal lEvent As Short, _
                        ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
                MyBase.New(crwFunctionResultHandler)

                _ret = 0
                _iPortNo = iPortNo
                _iRecMode = iRecMode
                _lTimeOut = lTimeOut
                _pResponseEventProc = pResponseEventProc
                _lParam = lParam
                _lEvent = lEvent

            End Sub

            ''' CRW関数呼出し
            Public Overrides Sub DoCall()
                _ret = crwSetResponseEventProc( _
                        _iPortNo, _
                        _iRecMode, _
                        _lTimeOut, _
                        _pResponseEventProc, _
                        _lParam, _
                        _lEvent)
            End Sub
        End Class
#End Region

#Region "(23) バイナリデータ受信イベントハンドラ登録関数呼出しクラス"
    ''' <summary>
    ''' (23) バイナリデータ受信イベントハンドラ登録関数呼出しクラス
    ''' </summary>
    Public Class CrwSetReceiveBinaryEventProcFunction
        Inherits CrwFunction

#Region " バイナリデータ受信イベントハンドラ登録関数 crwSetReceiveBinaryEventProc()"
        ''' <summary>
        ''' バイナリデータ受信イベントハンドラ登録関数 crwSetReceiveBinaryEventProc() 
        ''' </summary>
        ''' <param name="iPortNo">受信するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="lTimeOut">データの受信待ちタイマー値(単位:msec)（0 msec指定で無限待ち）</param>
        ''' <param name="pReceiveBinaryEventProc">crwReceiveBinaryEventProc関数のポインタ(NULLを指定:登録解除)</param>
        ''' <param name="pParam">アプリケーションによって定義された値</param>
        ''' <param name="lEvent">コールバック関数で受け取るイベントの論理和</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwSetReceiveBinaryEventProc( _
                                         ByVal iPortNo As Short, _
                                         ByVal lTimeOut As Int32, _
                                         ByVal pReceiveBinaryEventProc As CallBack, _
                                         ByVal pParam As Integer, _
                                         ByVal lEvent As Short) As Short
        End Function
#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _lTimeOut As Int32
        Public _pReceiveBinaryEventProc As CallBack
        Public _pParam As Integer
        Public _lEvent As Short
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="lTimeOut"></param>
        ''' <param name="pReceiveBinaryEventProc"></param>
        ''' <param name="pParam"></param>
        ''' <param name="lEvent"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                        ByVal iPortNo As Short, _
                        ByVal lTimeOut As Int32, _
                        ByVal pReceiveBinaryEventProc As CallBack, _
                        ByVal pParam As Integer, _
                        ByVal lEvent As Short, _
                    ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _lTimeOut = lTimeOut
            _pReceiveBinaryEventProc = pReceiveBinaryEventProc
            _pParam = pParam
            _lEvent = lEvent

        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwSetReceiveBinaryEventProc( _
                    _iPortNo, _
                    _lTimeOut, _
                    _pReceiveBinaryEventProc, _
                    _pParam, _
                    _lEvent)
        End Sub
    End Class
#End Region

#Region "(24) 通信イベントハンドラ登録関数呼出しクラス"
    ''' <summary>
    ''' (24) 通信イベントハンドラ登録関数呼出しクラス
    ''' </summary>
    Public Class CrwSetCommEventProcFunction
        Inherits CrwFunction

#Region " 通信イベントハンドラ登録関数 crwSetCommEventProc()"
        ''' <summary>
        ''' 通信イベントハンドラ登録関数 crwSetCommEventProc()
        ''' </summary>
        ''' <param name="iPortNo">監視するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="pCommEventProc">crwCommEventProc関数のポインタ(NULLを指定:登録解除)</param>
        ''' <param name="pParam">アプリケーションによって定義された値</param>
        ''' <param name="lEvent">コールバック関数で受け取るイベントの論理和</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwSetCommEventProc( _
                                         ByVal iPortNo As Short, _
                                         ByVal pCommEventProc As CallBack3, _
                                         ByVal pParam As Integer, _
                                         ByVal lEvent As Integer) As Short
        End Function
#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _pCommEventProc As CallBack3
        Public _pParam As Integer
        Public _lEvent As Integer
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="pCommEventProc"></param>
        ''' <param name="pParam"></param>
        ''' <param name="lEvent"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                        ByVal iPortNo As Short, _
                        ByVal pCommEventProc As CallBack3, _
                        ByVal pParam As Integer, _
                        ByVal lEvent As Integer, _
                    ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _pCommEventProc = pCommEventProc
            _pParam = pParam
            _lEvent = lEvent

        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwSetCommEventProc( _
                    _iPortNo, _
                    _pCommEventProc, _
                    _pParam, _
                    _lEvent)
        End Sub
    End Class
#End Region

#Region "(25)  IB Image Data 作成＆出力関数クラス"
    ''' <summary>
    ''' (25)  IB Image Data 作成＆出力関数クラス
    ''' </summary>
    Public Class CrwIBBinarySendFunction
        Inherits CrwFunction

#Region "IB Image Data 作成＆出力関数 crwIBBinarySend()"
        ''' <summary>
        ''' IB Image Data 作成＆出力関数 crwIBBinarySend()
        ''' </summary>
        ''' <param name="iPortNo">コマンドを送信するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="iRetryCount">データ送信、NAK 受信、及び SUNエラー受信時のリトライ回数</param>
        ''' <param name="lTimeOut">ACK/NAK待ち及びCTSオン待ちタイマー値（単位：msec）</param>
        ''' <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="iCTSCheck">CTSR信号線をチェックするかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="iWidth">印字エリアの横幅（機器の仕様書参考）例：320</param>
        ''' <param name="iHeigth">印字エリアの縦幅（機器の仕様書参考）例：460</param>
        ''' <param name="iStartY">印字開始位置(X座標) 例：100</param>
        ''' <param name="lComBufferSize">COMポート通信バッファーサイズ(バッファーサイズ合わせてデータを作成します)</param>
        ''' <param name="strPathFileName">イメージデータファイル</param>
        ''' <param name="bpCOMSTS">ステータス情報、またはコマンドコードを返却するエリアのポインタ（2バイト）</param>
        ''' <param name="bpERRSEN">センサー情報、またはエラーコードを返却するエリアのポインタ（2バイト）</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwIBBinarySend( _
                                                ByVal iPortNo As Short, _
                                                ByVal iRetryCount As Short, _
                                                ByVal iDSRCheck As Short, _
                                                ByVal iCTSCheck As Short, _
                                                ByVal iWidth As Short, _
                                                ByVal iHeigth As Short, _
                                                ByVal iStartY As Short, _
                                                ByVal lTimeOut As Int32, _
                                                ByVal lComBufferSize As Int32, _
                                                ByVal strPathFileName As String, _
                                                ByRef bpCOMSTS As System.IntPtr, _
                                                ByRef bpERRSEN As System.IntPtr _
                                                ) As Short

        End Function

#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _iRetryCount As Short
        Public _iDSRCheck As Short
        Public _iCTSCheck As Short
        Public _iWidth As Short
        Public _iHeigth As Short
        Public _iStartY As Short
        Public _lTimeOut As Int32
        Public _lComBufferSize As Int32
        Public _strPathFileName As String
        Public _bpCOMSTS As System.IntPtr
        Public _bpERRSEN As System.IntPtr
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="iRetryCount"></param>
        ''' <param name="lTimeOut"></param>
        ''' <param name="iDSRCheck"></param>
        ''' <param name="iCTSCheck"></param>
        ''' <param name="iWidth"></param>
        ''' <param name="iHeigth"></param>
        ''' <param name="iStartY"></param>
        ''' <param name="lComBufferSize"></param>
        ''' <param name="strPathFileName"></param>
        ''' <param name="bpCOMSTS"></param>
        ''' <param name="bpERRSEN"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                            ByVal iPortNo As Short, _
                            ByVal iRetryCount As Short, _
                            ByVal iDSRCheck As Short, _
                            ByVal iCTSCheck As Short, _
                            ByVal iWidth As Short, _
                            ByVal iHeigth As Short, _
                            ByVal iStartY As Short, _
                            ByVal lTimeOut As Int32, _
                            ByVal lComBufferSize As Int32, _
                            ByVal strPathFileName As String, _
                            ByRef bpCOMSTS As System.IntPtr, _
                            ByRef bpERRSEN As System.IntPtr, _
                            ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _iRetryCount = iRetryCount
            _iDSRCheck = iDSRCheck
            _iCTSCheck = iCTSCheck
            _iWidth = iWidth
            _iHeigth = iHeigth
            _iStartY = iStartY
            _lTimeOut = lTimeOut
            _lComBufferSize = lComBufferSize
            _strPathFileName = strPathFileName
            _bpCOMSTS = bpCOMSTS
            _bpERRSEN = bpERRSEN
        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwIBBinarySend( _
                                    _iPortNo, _
                                    _iRetryCount, _
                                    _iDSRCheck, _
                                    _iCTSCheck, _
                                    _iWidth, _
                                    _iHeigth, _
                                    _iStartY, _
                                    _lTimeOut, _
                                    _lComBufferSize, _
                                    _strPathFileName, _
                                    _bpCOMSTS, _
                                    _bpERRSEN)
        End Sub
    End Class
#End Region

#Region "(30)  PI Image Data 作成＆出力関数クラス"
    ''' <summary>
    ''' (30)  PI Image Data 作成＆出力関数クラス
    ''' </summary>
    Public Class crwPIDataSendFunction
        Inherits CrwFunction

#Region "PI Image Data 作成＆出力関数 crwPIDataSend()"
        ''' <summary>
        ''' PI Image Data 作成＆出力関数 crwPIDataSend()
        ''' </summary>
        ''' <param name="iPortNo">コマンドを送信するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name="iRetryCount">データ送信、NAK 受信、及び SUNエラー受信時のリトライ回数</param>
        ''' <param name="lTimeOut">ACK/NAK待ち及びCTSオン待ちタイマー値（単位：msec）</param>
        ''' <param name="iDSRCheck">DSR信号線をチェックするかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="iCTSCheck">CTSR信号線をチェックするかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="iWidth">印字エリアの横幅（機器の仕様書参考）例：320</param>
        ''' <param name="iHeigth">印字エリアの縦幅（機器の仕様書参考）例：460</param>
        ''' <param name="iStartX">印字開始位置(X座標) 例：100</param>
        ''' <param name="iStartY">印字開始位置(Y座標) 例：300</param>
        ''' <param name="lComBufferSize">COMポート通信バッファーサイズ(バッファーサイズ合わせてデータを作成します)</param>
        ''' <param name="strPathFileName">イメージデータファイル</param>
        ''' <param name="bpCOMSTS">ステータス情報、またはコマンドコードを返却するエリアのポインタ（2バイト）</param>
        ''' <param name="bpERRSEN">センサー情報、またはエラーコードを返却するエリアのポインタ（2バイト）</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwPIDataSend( _
                                                ByVal iPortNo As Short, _
                                                ByVal iRetryCount As Short, _
                                                ByVal iDSRCheck As Short, _
                                                ByVal iCTSCheck As Short, _
                                                ByVal iWidth As Short, _
                                                ByVal iHeigth As Short, _
                                                ByVal iStartX As Short, _
                                                ByVal iStartY As Short, _
                                                ByVal lTimeOut As Int32, _
                                                ByVal lComBufferSize As Int32, _
                                                ByVal strPathFileName As String, _
                                                ByRef bpCOMSTS As System.IntPtr, _
                                                ByRef bpERRSEN As System.IntPtr _
                                                ) As Short

        End Function

#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iPortNo As Short
        Public _iRetryCount As Short
        Public _iDSRCheck As Short
        Public _iCTSCheck As Short
        Public _iWidth As Short
        Public _iHeigth As Short
        Public _iStartX As Short
        Public _iStartY As Short
        Public _lTimeOut As Int32
        Public _lComBufferSize As Int32
        Public _strPathFileName As String
        Public _bpCOMSTS As System.IntPtr
        Public _bpERRSEN As System.IntPtr
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="iRetryCount"></param>
        ''' <param name="lTimeOut"></param>
        ''' <param name="iDSRCheck"></param>
        ''' <param name="iCTSCheck"></param>
        ''' <param name="iWidth"></param>
        ''' <param name="iHeigth"></param>
        ''' <param name="iStartX"></param>
        ''' <param name="iStartY"></param>
        ''' <param name="lComBufferSize"></param>
        ''' <param name="strPathFileName"></param>
        ''' <param name="bpCOMSTS"></param>
        ''' <param name="bpERRSEN"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                            ByVal iPortNo As Short, _
                            ByVal iRetryCount As Short, _
                            ByVal iDSRCheck As Short, _
                            ByVal iCTSCheck As Short, _
                            ByVal iWidth As Short, _
                            ByVal iHeigth As Short, _
                            ByVal iStartX As Short, _
                            ByVal iStartY As Short, _
                            ByVal lTimeOut As Int32, _
                            ByVal lComBufferSize As Int32, _
                            ByVal strPathFileName As String, _
                            ByRef bpCOMSTS As System.IntPtr, _
                            ByRef bpERRSEN As System.IntPtr, _
                            ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _iRetryCount = iRetryCount
            _iDSRCheck = iDSRCheck
            _iCTSCheck = iCTSCheck
            _iWidth = iWidth
            _iHeigth = iHeigth
            _iStartX = iStartX
            _iStartY = iStartY
            _lTimeOut = lTimeOut
            _lComBufferSize = lComBufferSize
            _strPathFileName = strPathFileName
            _bpCOMSTS = bpCOMSTS
            _bpERRSEN = bpERRSEN
        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwPIDataSend( _
                                    _iPortNo, _
                                    _iRetryCount, _
                                    _iDSRCheck, _
                                    _iCTSCheck, _
                                    _iWidth, _
                                    _iHeigth, _
                                    _iStartX, _
                                    _iStartY, _
                                    _lTimeOut, _
                                    _lComBufferSize, _
                                    _strPathFileName, _
                                    _bpCOMSTS, _
                                    _bpERRSEN)
        End Sub
    End Class
#End Region

#Region "(31) 電文データ受信イベントハンドラ登録関数呼出しクラス"
    ''' <summary>
    ''' (22) 電文データ受信イベントハンドラ登録関数呼出しクラス
    ''' </summary>
    Public Class CrwSetReceiveDataBCCEventProcFunction
        Inherits CrwFunction

#Region " 電文データ受信イベントハンドラ登録関数 crwSetReceiveDataBCCEventProc()"
        ''' <summary>
        ''' 電文データ受信イベントハンドラ登録関数 crwSetReceiveDataBCCEventProc() 
        ''' </summary>
        ''' <param name="iPortNo">受信するシリアルポートの番号（例：COM1なら”1”）</param>
        ''' <param name=" iACKResponse">ACK/NAKを返却するかどうかのフラグ（0以外：する / 0：しない）</param>
        ''' <param name="lTimeOut">データの受信待ちタイマー値(単位:msec) （0 msec指定で無限待ち）</param>
        ''' <param name="pReceiveDataBCCEventProc">crwReceiveDataBCCEventProc関数のポインタ(NULLを指定:登録解除)</param>
        ''' <param name="lParam">アプリケーションによって定義された値</param>
        ''' <param name="lEvent">コールバック関数で受け取るイベントの論理和</param>
        ''' <returns>整数型(short)</returns>
        <DllImport("PCardRW64.dll")> _
        Private Shared Function crwSetReceiveDataBCCEventProc( _
                                         ByVal iPortNo As Short, _
                                         ByVal iACKResponse As Short, _
                                         ByVal lTimeOut As Int32, _
                                         ByVal pReceiveDataBCCEventProc As CallBack4, _
                                         ByVal lParam As Integer, _
                                         ByVal lEvent As Short) As Short
        End Function
#End Region

#Region "メンバフィールド定義"
        Public _ret As Short
        Public _iACKResponse As Short
        Public _iPortNo As Short
        Public _lTimeOut As Int32
        Public _pReceiveDataBCCEventProc As CallBack4
        Public _lParam As Integer
        Public _lEvent As Short
#End Region

        ''' <summary>
        ''' コンストラクタ
        ''' </summary>
        ''' <param name="iPortNo"></param>
        ''' <param name="iACKResponse"></param>
        ''' <param name="lTimeOut"></param>
        ''' <param name="pReceiveDataBCCEventProc"></param>
        ''' <param name="lParam"></param>
        ''' <param name="lEvent"></param>
        ''' <param name="crwFunctionResultHandler"></param>
        ''' <remarks></remarks>
        Public Sub New( _
                        ByVal iPortNo As Short, _
                        ByVal iACKResponse As Short, _
                        ByVal lTimeOut As Int32, _
                        ByVal pReceiveDataBCCEventProc As CallBack4, _
                        ByVal lParam As Integer, _
                        ByVal lEvent As Short, _
                    ByRef crwFunctionResultHandler As CrwFunctionResultHandler)
            MyBase.New(crwFunctionResultHandler)

            _ret = 0
            _iPortNo = iPortNo
            _iACKResponse = iACKResponse
            _lTimeOut = lTimeOut
            _pReceiveDataBCCEventProc = pReceiveDataBCCEventProc
            _lParam = lParam
            _lEvent = lEvent

        End Sub

        ''' CRW関数呼出し
        Public Overrides Sub DoCall()
            _ret = crwSetReceiveDataBCCEventProc( _
                    _iPortNo, _
                    _iACKResponse, _
                    _lTimeOut, _
                    _pReceiveDataBCCEventProc, _
                    _lParam, _
                    _lEvent)
        End Sub
    End Class
#End Region

End Namespace


