﻿'名前空間を定義　----------------------
Imports System.Runtime.InteropServices
Imports VB = Microsoft.VisualBasic
Imports System.IO
Imports System.Threading

Namespace VB_sample

    Public Class Worker

#Region "メンバ変数定義"
        Private _crwFunctionEvent As EventWaitHandle    ' イベントハンドル（CRW関数呼出し通知）

        Private _exitThreadEvent As EventWaitHandle     ' イベントハンドル（スレッド終了通知）


        Private _Thread As Thread                       ' スレッド

        Private _crwFunction As CrwFunction             ' 呼出し対象のCRW関数
        Public _threadname As String

#End Region

#Region "コンストラクタ"
        Public Sub New(ByVal threadname As String)
            _crwFunctionEvent = New AutoResetEvent(False)
            _exitThreadEvent = New AutoResetEvent(False)
            _Thread = New Thread(New ThreadStart(AddressOf Me.ThreadRun))
            _Thread.Start()
            _threadname = threadname
        End Sub
#End Region

#Region "CRW関数呼び出し"
        ''' CRW関数呼出し
        Public Function CallCrwFunction(ByVal crwFunction As CrwFunction) As String

            _crwFunction = crwFunction
            ' EventWaitHandleのSetメンバは
            ' イベントの状態をシグナル状態に設定し、待機している 1 つ以上のスレッドが進行できる
            ' シグナル状態をグリーンにする、これを行うと
            ' WaitHandle.WaitAny(eventArray)をとおりぬけることが出来る

            _crwFunctionEvent.Set()


            Return _threadname
        End Function
#End Region

#Region "ワーカスレッド終了"
        ' ワーカスレッド終了

        Public Sub TerminateThread()       ' ターミネートスレッド
            _exitThreadEvent.Set()         ' イベントを青信号
            _Thread.Join()                 ' 呼び出し元のスレッドをブロック(これが終了処理?)    
    #end sub
#End Region

#Region "ワーカスレッド本体"

        Private Sub ThreadRun()

            Dim eventArray() As WaitHandle = New WaitHandle() {_crwFunctionEvent, _exitThreadEvent}

            ' スレッドのメインループ

            While 1 <> WaitHandle.WaitAny(eventArray)   ' ここで待機


                _crwFunction.CallFunk()                 ' ここで実行


            End While

        End Sub

#End Region

#Region "ワーカスレッド名前を取得"

        Public Function getName() As String
            Return _threadname
        End Function
#End Region
    End Class

End Namespace
